<?php

namespace App\Models;
use App\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Auth;

class Package extends Model
{

    //soft delete
    use SoftDeletes;
    //timestamp
    public $timestamps = true;
    //table
    protected $table = "packages";
    protected $fillable = [
        'name_en',
        'name_ar',
        'status',
    ];
    public static function boot()
    {
        parent::boot();


        static::creating(function(Package $row)
        {
            $row->created_by = Auth::id();
        });

        static::created(function(Package $row)
        {
            set_log('Package','insert',$row->id);
        });
        static::updated(function(Package $row)
        {
            set_log('Package','update',$row->id);
        });
        static::deleted(function(Package $row)
        {
            set_log('Package','delete',$row->id);
        });
    }
    public function services(){
        return $this->hasMany(PackageService::class,'package_id');
    }

    public function created_by_user(){
        return $this->belongsTo(User::class,'created_by');
    }
}
