<?php

namespace App\Models;
use App\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
class PackageService extends Model
{

    //timestamp
    public $timestamps = true;
    //table
    protected $table = "packages_services";
    protected $fillable = [
        'package_id',
        'service_id',
        'is_free',
    ];
    public static function boot()
    {
        parent::boot();
        static::created(function(PackageService $row)
        {
            set_log('packages_services','insert',$row->id);
        });
        static::updated(function(PackageService $row)
        {
            set_log('packages_services','update',$row->id);
        });
        static::deleted(function(PackageService $row)
        {
            set_log('packages_services','delete',$row->id);
        });
    }
    public function service(){
        return $this->belongsTo(Service::class,'service_id');
    }
}
