<?php

namespace App\Models;
use App\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Auth;

class Wallet extends Model
{

    //soft delete
    use SoftDeletes;
    //timestamp
    public $timestamps = true;
    //table
    protected $table = "wallets";
    protected $fillable = [
        'code',
        'type',
        'amount',
        'invoiced_amount',
        'start_at',
        'end_at',
        'status',
    ];
    public static function boot()
    {
        parent::boot();

        static::creating(function(Wallet $row)
        {
            $row->created_by = Auth::id();
        });

        static::created(function(Wallet $row)
        {
            set_log('Wallet','insert',$row->id);
        });
        static::updated(function(Wallet $row)
        {
            set_log('Wallet','update',$row->id);
        });
        static::deleted(function(Wallet $row)
        {
            set_log('Wallet','delete',$row->id);
        });
    }
    public function users(){
        return $this->hasMany(UserWallet::class,'wallet_id');
    }
    public function created_by_user(){
        return $this->belongsTo(User::class,'created_by');
    }
}
