<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Route;

class RouteServiceProvider extends ServiceProvider
{
    /**
     * This namespace is applied to your controller routes.
     *
     * In addition, it is set as the URL generator's root namespace.
     *
     * @var string
     */
    protected $namespace = 'App\Http\Controllers';
    public const HOME = '/home';
    public function boot()
    {
        parent::boot();
    }

    public function map()
    {
        $this->mapApiRoutes();
        $this->mapWebRoutes();
        $this->mapAccountRoutes();
        $this->mapBranchRoutes();
        $this->mapShiftRoutes();
        $this->mapServiceRoutes();
        $this->mapWorkerRoutes();
        $this->mapCustomerRoutes();
        $this->mapProductRoutes();
        $this->mapBookingRoutes();
        $this->mapReportRoutes();
    }
    protected function mapWebRoutes()
    {
        Route::middleware('web')
             ->namespace($this->namespace)
             ->group(base_path('routes/web.php'));
    }
    protected function mapApiRoutes()
    {
        Route::prefix('api')
             ->middleware('api')
             ->namespace($this->namespace)
             ->group(base_path('routes/api.php'));
    }
    protected function mapAccountRoutes(){
        Route::middleware('web')
            ->namespace($this->namespace)
            ->group(base_path('routes/account/index.php'));
    }
    protected function mapBranchRoutes(){
        Route::middleware('web')
            ->namespace($this->namespace)
            ->group(base_path('routes/branch/index.php'));
    }
    protected function mapShiftRoutes(){
        Route::middleware('web')
            ->namespace($this->namespace)
            ->group(base_path('routes/shift/index.php'));
    }
    protected function mapServiceRoutes(){
        Route::middleware('web')
            ->namespace($this->namespace)
            ->group(base_path('routes/service/index.php'));
    }
    protected function mapWorkerRoutes(){
        Route::middleware('web')
            ->namespace($this->namespace)
            ->group(base_path('routes/worker/index.php'));
    }
    protected function mapCustomerRoutes(){
        Route::middleware('web')
            ->namespace($this->namespace)
            ->group(base_path('routes/customer/index.php'));
    }

    protected function mapProductRoutes(){
        Route::middleware('web')
            ->namespace($this->namespace)
            ->group(base_path('routes/product/index.php'));
    }

    protected function mapBookingRoutes(){
        Route::middleware('web')
            ->namespace($this->namespace)
            ->group(base_path('routes/booking/index.php'));
    }

    protected function mapReportRoutes(){
        Route::middleware('web')
            ->namespace($this->namespace)
            ->group(base_path('routes/report/index.php'));
    }
}
