<?php

namespace App;

use App\Models\Branch;
use App\Models\Role;
use App\Models\UserWallet;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Facades\Auth;
use Tymon\JWTAuth\Contracts\JWTSubject;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Authenticatable implements JWTSubject
{
    use  Notifiable;
    use SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'first_name',
        'last_name',
        'branch_id',
        'email',
        'password',
        'country_code',
        'phone',
        'image',
        'is_active',
        'role_id',
        'created_by',
        'remember_token'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    /**
     * Get the identifier that will be stored in the subject claim of the JWT.
     *
     * @return mixed
     */
    public function getJWTIdentifier() {
        return $this->getKey();
    }

    /**
     * Return a key value array, containing any custom claims to be added to the JWT.
     *
     * @return array
     */
    public function getJWTCustomClaims() {
        return [];
    }
    public static function boot()
    {
        parent::boot();

        static::creating(function(User $row)
        {
            $row->created_by = Auth::id();
        });

        static::created(function(User $row)
        {
            set_log('User','insert',$row->id);
        });
        static::updated(function(User $row)
        {
            set_log('User','update',$row->id);
        });
        static::deleted(function(User $row)
        {
            set_log('User','delete',$row->id);
        });
    }
    public function role(){
        return $this->belongsTo(Role::class,'role_id');
    }
    public function branch(){
        return $this->belongsTo(Branch::class,'branch_id');
    }
    public function wallet_list(){
        return $this->hasMany(UserWallet::class,'user_id');
    }
}
