<?php
function company()
{
    return Config::get('constants.company');
}

function customer()
{
    return Config::get('constants.customer');
}

function customer_website()
{
    return Config::get('constants.customer_website');
}

function user_session()
{
    return Config::get('constants.session');
}

function user()
{
    return Illuminate\Support\Facades\Auth::user();
}

//send request
function doRequest($url = "", $method = "", $data = [], $token = "", $Authorization = "", $is_die = false)
{
    //get api key
    $settings = App\Models\PortalSettings::where('meta_key', 'api_key')->get()->first();
    $api_key = $settings->meta_value;
    //send request
    $curl = curl_init();
    $params = array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => strtoupper($method),
        CURLOPT_HTTPHEADER => array(
            'x-api-key: ' . $api_key,
            'Content-Type: application/json',
            'token: ' . $token,
            'Authorization: ' . $Authorization
        ),
    );
    if (strtolower($method) == "post" || strtolower($method) == "put") {
        $params[CURLOPT_POSTFIELDS] = json_encode($data);
    }
    curl_setopt_array($curl, $params);
    $response = curl_exec($curl);
    curl_close($curl);
    if ($is_die) {
        print_r($response);
        die;
    }
    return json_decode($response, true);


}

//encrypt and decrypt
function encryptTo($string)
{
    $settings = App\Models\PortalSettings::where('meta_key', 'encryption_key')->get()->first();
    $encryption_key = $settings->meta_value;
    $ciphering = "AES-128-CTR";
    $options = 0;
    $encryption_iv = '1234567891011121';
    $encryption = openssl_encrypt($string, $ciphering,
        $encryption_key, $options, $encryption_iv);
    return $encryption;
}

function decryptTo($text = "")
{
    $ciphering = "AES-128-CTR";
    $decryption_iv = '1234567891011121';
    $options = 0;
    $decryption_key = App\Models\PortalSettings::where('meta_key', '=', 'encryption_key')->first()->meta_value;
    return openssl_decrypt($text, $ciphering,
        $decryption_key, $options, $decryption_iv);
}

//user
function generate_access_token()
{
    $token = openssl_random_pseudo_bytes(32) . time();
    $token = bin2hex($token);
    return $token;
}

//email
function _sendEmail($info = [])
{
    $to = $info['to'];
    $cc = (isset($info['cc'])) ? $info['cc'] : [];
    $subject = $info['subject'];
    $message = $info['message'];
    $list_attachment = (isset($info['attach'])) ? $info['attach'] : [];
    \Mail::send([], [], function ($email) use ($to, $cc, $subject, $message, $list_attachment) {
        $email->from("noreply@allin1uae.com", customer());
        foreach ($to as $val) {
            $email->to($val['email'], $val['name']);
        }

        if (!empty($cc)) {
            foreach ($cc as $val) {
                $email->cc($val['email'], $val['name']);
            }
        }

        $email->subject($subject);
        $email->setBody($message, 'text/html');

        if (!empty($list_attachment)) {
            foreach ($list_attachment as $val) {
                $email->attach($val);
            }
        }
    });
}

//logs
function set_log($name, $type, $row_id)
{
    \App\Models\Log::create([
        'name' => $name,
        'type' => $type,
        'row_id' => $row_id
    ]);
}

function set_message($message, $type = "success")
{
    session(
        [
            'error' => ['message' => $message, 'type' => $type]
        ]
    );
}

//get permission
function get_permissions()
{
    $result = [];
    $permissions = \App\Models\Permission::all();
    foreach ($permissions as $permission) {
        $result[$permission->group][$permission->id] = $permission->meta_key;
    }
    return $result;
}

function get_permission_role($role_id)
{
    $permissions = \App\Models\Role::where('id', $role_id)
        ->with('permissions')
        ->get()->first();
    if (!empty($permissions)) {
        if (count($permissions->permissions) == 0) {
            return false;
        }
    } else {
        return false;
    }
    return $permissions->permissions;
}

function set_permissions($permissions)
{
    $array = [];
    foreach ($permissions as $permission) {
        $temp = strtolower(str_replace(' ', '_', $permission->group));
        $temp .= "." . strtolower(str_replace(' ', '_', $permission->meta_key));
        $array[$temp] = true;
    }
    session(
        [
            'permissions' => $array
        ]
    );
}

function can($key, $with_redirect = false)
{
    return true;
    if ($key == "supplier.view") {
        $key = "provider.view";
    }
    if ($key == "supplier.create") {
        $key = "provider.create";
    }
    if ($key == "supplier.edit") {
        $key = "provider.edit";
    }
    if ($key == "supplier.delete") {
        $key = "provider.delete";
    }
    if (\Illuminate\Support\Facades\Auth::user()->id == 1) {
        return true;
    }
    if (\Illuminate\Support\Facades\Session::has('permissions') && array_key_exists($key, \Illuminate\Support\Facades\Session::get('permissions'))) {
        return true;
    }
    if ($with_redirect) {
        \App\Http\Controllers\DashboardController::r();
    }
    return false;
}

function currencies()
{
    return \App\Models\Currency::all();
}

function can_settings()
{
    if (
        can('user.view') ||
        can('role.view') ||
        can('hotel.view') ||
        can('client.view') ||
        can('supplier.view') ||
        can('airline.view') ||
        can('service.view') ||
        can('hall.view') ||
        can('tour.view') ||
        can('room.view') ||
        can('hotel_reservation_type.view') ||
        can('email_template.view') ||
        can('whtassapp_template.view') ||
        can('car.view')
    ) {
        return true;
    }
    return false;
}

/*function get_reservation_number(){
    $q = \App\Models\Reservation::limit(1)->orderBy('id','desc')->first();
    if(empty($q->reservation_number)){
        return sprintf("%08d", 1);
    }
    return sprintf("%08d", $q->reservation_number + 1);
}*/
function get_reservation_number($client_id)
{
    //get country id
    $client = \App\Models\Client::find($client_id);
    if (!empty($client) && !empty($client->city) && !empty($client->city->country) && !empty($client->city->country->iso3)) {
        $year = date('y');
        $country_code = $client->city->country->iso3;
        //get country count
        $country_count = \App\Models\ReservationCounter::where('country_id', $client->city->country_id)->first();
        if (empty($country_count)) {
            $country_count = sprintf("%05d", 1);
        } else {
            $country_count = sprintf("%05d", $country_count->country_count + 1);
        }
        return $year . $country_code . $country_count;
    }
    return false;
}

function update_reservation_number($client_id)
{
    //get country id
    $client = \App\Models\Client::find($client_id);
    if (!empty($client) && !empty($client->city) && !empty($client->city->country) && !empty($client->city->country->iso3)) {
        $country_count = \App\Models\ReservationCounter::where('country_id', $client->city->country_id)->first();
        if (empty($country_count)) {
            \App\Models\ReservationCounter::create([
                'country_count' => 1,
                'country_id' => $client->city->country_id
            ]);
        } else {
            $country_count->country_count = $country_count->country_count + 1;
            $country_count->save();
        }
    }
}

function get_num_format($number, $decimals = 2)
{
    return number_format($number, $decimals);
}

function get_resv_total($resv_id,$type = "")
{
    $result = [];
    $hotels_re = [];
    $services_re = [];
    $tours_re = [];
    $transfer_re = [];
    $airlines_re = [];
    $halls_re = [];
    $currencies = \App\Models\Currency::all();
    if (!empty($currencies)) {
        foreach ($currencies as $currency) {
            $result[$currency->id] = 0;
            $hotels_re[$currency->id] = 0;
            $services_re[$currency->id] = 0;
            $tours_re[$currency->id] = 0;
            $transfer_re[$currency->id] = 0;
            $airlines_re[$currency->id] = 0;
            $halls_re[$currency->id] = 0;
        }
    }
    $resv = \App\Models\Reservation::find($resv_id);
    /* hotels */
    if (!empty($resv->hotels)) {
        foreach ($resv->hotels as $hotel) {
            if (strtolower(trim($hotel->status)) !== "cancel") {
                $per_night = get_hotel_night(get_hotel_date($hotel->check_in, $hotel->check_out));
                if (!empty($hotel->rooms)) {
                    foreach ($hotel->rooms as $room) {
                        if (isset($result[$room->price_currency_id])) {
                            $result[$room->price_currency_id] += $room->price * $per_night;
                            $hotels_re[$room->price_currency_id] += $room->price * $per_night;
                        }
                    }
                }
            } else {
                if (!$hotel->total_cost_price->isEmpty()) {
                    foreach ($hotel->total_cost_price as $item) {
                        $result[$item->currency_id] += $item->total_price;
                        $hotels_re[$item->currency_id] += $item->total_price;
                    }
                }
            }
        }
        if($type=="hotel"){
            return $hotels_re;
        }
    }
    /* services */
    if (!empty($resv->services)) {
        foreach ($resv->services as $service) {
            $result[$service->price_currency_id] += $service->price;
            $services_re[$service->price_currency_id] += $service->price;
        }
        if($type=="service"){
            return $services_re;
        }
    }
    /* tours */
    if (!empty($resv->tours)) {
        foreach ($resv->tours as $tour) {
            if (!empty($tour->persons)) {
                foreach ($tour->persons as $person) {
                    $result[$person->price_currency_id] += $person->price;
                    $tours_re[$person->price_currency_id] += $person->price;
                }
            }
        }
        if($type=="tour"){
            return $tours_re;
        }
    }
    /* transfer */
    if (!empty($resv->transfer)) {
        foreach ($resv->transfer as $transfer) {
            if (!empty($transfer->persons)) {
                foreach ($transfer->persons as $person) {
                    $result[$person->price_currency_id] += $person->price;
                    $transfer_re[$person->price_currency_id] += $person->price;
                }
            }
        }
        if($type=="transfer"){
            return $transfer_re;
        }
    }
    /* airline */
    if (!empty($resv->airline)) {
        foreach ($resv->airline as $airline) {
            if (!empty($airline->persons)) {
                foreach ($airline->persons as $person) {
                    $result[$person->price_currency_id] += $person->price;
                    $airlines_re[$person->price_currency_id] += $person->price;
                }
            }
        }
        if($type=="airline"){
            return $airlines_re;
        }
    }
    /* halls */
    if (!empty($resv->halls)) {
        foreach ($resv->halls as $hall) {
            $per_night = get_hotel_night(get_hotel_date($hall->from_date, $hall->to_date)) + 1;
            if (!empty($hall->persons)) {
                foreach ($hall->persons as $person) {
                    $result[$person->price_currency_id] += $person->price * $per_night;
                    $halls_re[$person->price_currency_id] += $person->price * $per_night;
                }
            }
        }
        if($type=="hall"){
            return $halls_re;
        }
    }

    return $result;
}

function get_hotel_night($check_in_out_date)
{
    $explode = explode('-', $check_in_out_date);
    if (!empty($explode)) {
        $explode[0] = trim($explode[0]);
        $explode[1] = trim($explode[1]);
        //convert
        $explode[0] = DateTime::createFromFormat('d/m/Y', $explode[0]);
        $explode[1] = DateTime::createFromFormat('d/m/Y', $explode[1]);
        //get format
        $explode[0] = $explode[0]->format('Y-m-d');
        $explode[1] = $explode[1]->format('Y-m-d');

        $datetime1 = date_create($explode[0]);
        $datetime2 = date_create($explode[1]);
        if ($datetime1 != false && $datetime2 != false) {
            $interval = date_diff($datetime1, $datetime2);
            return $interval->format('%a');
        } else {
            return 1;
        }
    } else {
        return 1;
    }
}

function get_check_in_out($check_in_out)
{
    $explode = explode('-', $check_in_out);
    if (!empty($explode) && (isset($explode[0]) && !empty($explode[0]))) {
        $explode[0] = trim($explode[0]);
        $explode[1] = trim($explode[1]);
        return [
            'check_in' => $explode[0],
            'check_out' => $explode[1]
        ];
    }

    return [
        'check_in' => '',
        'check_out' => ''
    ];
}

function get_hotel_date($check_in, $check_out)
{
    if(empty($check_in) || empty($check_out)){
        return "";
    }
    return "$check_in - $check_out";
}

function get_limit()
{
    return 10;
}

function my_date($date, $with_time = false)
{
    if(empty($date)){
        return "";
    }
    if (!is_numeric($date)) {
        $date = strtotime($date);
    }
    return ($with_time) ? date('d/m/Y h:i:s A', $date) : date('d/m/Y', $date);
}

function get_ticket_type()
{
    return [
        'one_way' => 'One Way',
        'round_trip' => 'Round Trip'
    ];
}

function convert_date($date)
{
    if(empty($date)){
        return "";
    }
    $date = DateTime::createFromFormat('d/m/Y', $date);
    $date = $date->format('Y-m-d');
    return $date;
}

function get_date_type()
{
    return [
        'booking_date' => 'Booking Date',
        'check_in' => 'Check In',
        'check_out' => 'Check Out',
    ];
}

function get_resv_ids($resv_list)
{
    $result = [];
    if (!empty($resv_list)) {
        foreach ($resv_list as $item) {
            array_push($result, $item->id);
        }
    }
    return $result;
}

function get_supplier_types()
{
    return [
        'hotel' => __('s.hotel'),
        'service' => __('s.service'),
        'tour' => __('s.tour'),
        'transfer' => __('s.transfer'),
        'airline' => __('s.airline'),
        'hall' => __('s.hall')
    ];
}

function get_main_type()
{
    return [
        'hotel' => __('s.hotel'),
        'supplier' => __('s.supplier')
    ];
}

function get_date_filter_type()
{
    return [
        'reservation_date' => __('s.reservation_date'),
        'check_in' => __('s.check_in'),
        'check_out' => __('s.check_out'),
    ];
}

function get_transfer_types()
{
    return [
        'departures' => __('s.departures'),
        'arrivals' => __('s.arrivals')
    ];
}

function get_operation_limit()
{
    return 50;
}

function get_address()
{
    return "İnonü mah. Cumhuriyet cad. Mutlu ap. <br>
No 131 , D 1<br>
Şişli , İstanbul , Turkiye";
}

function get_phone()
{
    return "+90 212 234 95 78";
}

function fax()
{
    return "+90 212 234 95 79";
}

function get_operation()
{
    return "+90 533 509 5094";
}

function get_email()
{
    return "info@ogarite.com";
}

function get_website()
{
    return "http://www.ogarite.com/";
}

function get_fax()
{
    return "+90 212 234 95 79";
}

function get_suppliers_types_list()
{
    return [
        'hotel' => __('s.hotel'),
        'service' => __('s.service'),
        'transfer' => __('s.cars'),
        'tour' => __('s.tour'),
        'airline' => __('s.airline'),
        'hall' => __('s.hall')
    ];
}

function get_clients()
{
    return \App\Models\Client::all();
}

function get_resv_persons($resv_id)
{
    $resv = \App\Models\Reservation::find($resv_id);
    $persons = [];
    $has_hotels = false;
    if (!$resv->hotels->isEmpty()) {
        foreach ($resv->hotels as $hotel) {
            if (!$hotel->persons->isEmpty()) {
                foreach ($hotel->persons as $person) {
                    $temp = [];
                    $temp['id'] = $person->id;
                    $temp['type'] = 'hotel';
                    $temp['name'] = $person->first_name . ' ' . $person->last_name;
                    $persons[] = $temp;
                    $has_hotels = true;
                    break;
                }
            }
        }
    }

    //tours
    if (!$resv->tours->isEmpty()) {
        foreach ($resv->tours as $tour) {
            if (!$tour->persons->isEmpty()) {
                foreach ($tour->persons as $person) {
                    if(!empty($person->reservation_hotel_person_id)){
                        continue;
                    }
                    $temp = [];
                    $temp['id'] = $person->id;
                    $temp['type'] = 'tour';
                    $temp['name'] = $person->first_name . ' ' . $person->last_name;
                    $persons[] = $temp;
                }
            }
        }
    }
    //transfer
    if (!$resv->transfer->isEmpty()) {
        foreach ($resv->transfer as $transfer) {
            if (!$transfer->persons->isEmpty()) {
                foreach ($transfer->persons as $person) {
                    if(!empty($person->reservation_hotel_person_id)){
                        continue;
                    }
                    $temp = [];
                    $temp['id'] = $person->id;
                    $temp['type'] = 'transfer';
                    $temp['name'] = $person->first_name . ' ' . $person->last_name;
                    $persons[] = $temp;
                }
            }
        }
    }
    //airline
    if (!$resv->airline->isEmpty()) {
        foreach ($resv->airline as $airline) {
            if (!$airline->persons->isEmpty()) {
                foreach ($airline->persons as $person) {
                    if(!empty($person->reservation_hotel_person_id)){
                        continue;
                    }
                    $temp = [];
                    $temp['id'] = $person->id;
                    $temp['type'] = 'airline';
                    $temp['name'] = $person->first_name . ' ' . $person->last_name;
                    $persons[] = $temp;
                }
            }
        }
    }
    //halls
    if (!$resv->halls->isEmpty()) {
        foreach ($resv->halls as $hall) {
            if (!$hall->persons->isEmpty()) {
                foreach ($hall->persons as $person) {
                    $temp = [];
                    $temp['id'] = $person->id;
                    $temp['type'] = 'hall';
                    $temp['name'] = $person->first_name . ' ' . $person->last_name;
                    $persons[] = $temp;
                }
            }
        }
    }

    return $persons;
}
function get_hotel_status(){
    return [
        ''=>__('s.all'),
        'amended'=>__('s.amended'),
        'canceled'=>__('s.canceled')
    ];
}
function get_leader_name($resv){
    $name = "";
    if(!empty($resv->leader)){
        if($resv->leader->person_type=="hotel"){
            $hotel_person = \App\Models\ReservationHotelPerson::find($resv->leader->person_id);
            if(!empty($hotel_person)){
                $name = $hotel_person->first_name.' '.$hotel_person->last_name;
            }
        }
        if($resv->leader->person_type=="tour"){
            $tour_person = \App\Models\ReservationTourPerson::find($resv->leader->person_id);
            if(!empty($tour_person)){
                $name = $tour_person->first_name.' '.$tour_person->last_name;
            }
        }
        if($resv->leader->person_type=="transfer"){
            $transfer_person = \App\Models\ReservationTransferPerson::find($resv->leader->person_id);
            if(!empty($transfer_person)){
                $name = $transfer_person->first_name.' '.$transfer_person->last_name;
            }
        }
        if($resv->leader->person_type=="airline"){
            $airline_person = \App\Models\ReservationAirlinePerson::find($resv->leader->person_id);
            if(!empty($airline_person)){
                $name = $airline_person->first_name.' '.$airline_person->last_name;
            }
        }
        if($resv->leader->person_type=="hall"){
            $hall_person = \App\Models\ReservationAirlinePerson::find($resv->leader->person_id);
            if(!empty($hall_person)){
                $name = $hall_person->first_name.' '.$hall_person->last_name;
            }
        }
    }
    return $name;
}

function prep_message($message, $object, $type = "")
{
    $hotel_name = "";
    $hotel_email = "";
    $hotel_phone = "";
    $hotel_city = "";
    $hotel_check_in_out = "";
    $hotel_confirm_number = "";
    $hotel_night_count = "";
    $client_company = "";
    $client_email = "";
    $client_phone = "";
    if(isset($object->client) && !empty($object->client)){
        $client_company = $object->client->company;
        $client_email = $object->client->email;
        $client_phone = $object->client->phone;
    }
    if(isset($object->hotel) && !empty($object->hotel)){
        $hotel_name = $object->hotel->name;
        $hotel_email = $object->hotel->email;
        $hotel_phone = $object->hotel->phone;
        $hotel_city = (isset($object->hotel->city) && !empty($object->hotel->city)) ? $object->hotel->city->name:'';
        $hotel_check_in_out = (isset($object->check_in) && isset($object->check_out)) ? $object->check_in.'-'.$object->check_out:'';
        $hotel_confirm_number = (isset($object->voucher)) ? $object->voucher:'';
        $hotel_night_count = (isset($object->check_in) && isset($object->check_out)) ? get_hotel_night(get_hotel_date($object->check_in,$object->check_out)):'';
    }

    $search = array(
        'INSERT_HOTEL_NAME',
        'INSERT_HOTEL_EMAIL',
        'INSERT_HOTEL_PHONE',
        'INSERT_HOTEL_CITY',
        'INSERT_HOTEL_CHECK_IN_CHECK_OUT',
        'INSERT_HOTEL_CONFIRM_NUMBER',
        'INSERT_HOTEL_NIGHT_COUNT',
        'INSERT_CLIENT_COMPANY',
        'INSERT_CLIENT_EMAIL',
        'INSERT_CLIENT_PHONE',
    );
    $replace = array(
        $hotel_name,
        $hotel_email,
        $hotel_phone,
        $hotel_city,
        $hotel_check_in_out,
        $hotel_confirm_number,
        $hotel_night_count,
        $client_company,
        $client_email,
        $client_phone
    );
    return str_replace($search, $replace, $message);
}
function get_hotel_persons($resv_row,$person){
    $result = [
        'first_name'=>'',
        'last_name'=>'',
        'phone'=>'',
        'hotel'=>'',
        'hotel_id'=>0,
        'check_in'=>'',
        'check_out'=>''
    ];
    if(isset($person['reservation_hotel_person_id']) && !empty($person['reservation_hotel_person_id'])){
        if(isset($resv_row['hotels']) && !empty($resv_row['hotels'])){
            foreach ($resv_row['hotels'] as $hotel){
                if(isset($hotel['persons']) && !empty($hotel['persons'])){
                    foreach ($hotel['persons'] as $hotel_person){
                        if($hotel_person['id']==$person['reservation_hotel_person_id']){
                            $result['first_name'] = $hotel_person['first_name'];
                            $result['last_name'] = $hotel_person['last_name'];
                            $result['phone'] = $hotel_person['phone'];
                            $result['hotel'] = (isset($hotel['hotel'])) ? $hotel['hotel']['name']:'';
                            $result['hotel_id'] = (isset($hotel['hotel'])) ? $hotel['hotel']['id']:'';
                            $result['check_in'] = $hotel['check_in'];
                            $result['check_out'] = $hotel['check_out'];
                        }
                    }
                }
            }
        }
    }
    return $result;
}
function get_sequence($current){
    $result = [
      0=>'A',
      1=>'B',
      2=>'C',
      3=>'D',
      4=>'E',
      5=>'F',
      6=>'G',
      7=>'H',
      8=>'I',
      9=>'J',
      10=>'K',
      11=>'L',
      12=>'M',
      13=>'N',
      14=>'O',
      15=>'P',
      16=>'Q',
      17=>'R',
      18=>'S',
      19=>'T',
      20=>'U',
      21=>'V',
      22=>'W',
      23=>'X',
      24=>'Y',
      25=>'Z',
        26=>'AA',
        27=>'AB',
        28=>'AC',
        29=>'AD',
        30=>'AE',
        31=>'AF',
        32=>'AG',
        33=>'AH',
        34=>'AI',
        35=>'AJ',
        36=>'AK',
        37=>'AL',
        38=>'AM',
        39=>'AN',
        40=>'AO',
        41=>'AP',
        42=>'AQ',
        43=>'AR',
        44=>'AS',
        45=>'AT',
        46=>'AU',
        47=>'AV',
        48=>'AW',
        49=>'AX',
        50=>'AY',
        51=>'AZ',
    ];
    $current_index = array_search($current,$result);
    $next_index = $current_index+1;
    return (isset($result[$next_index])) ? $result[$next_index]:'';
}
function set_route($route_name,$params = []){
    $params['locale'] = app()->getLocale();
    return url(route($route_name,$params));
}
function get_currency(){
    return "AED ";
}
function get_user_role(){
    $role_id = 0;
    $user = \App\User::find(\Illuminate\Support\Facades\Auth::id());
    if(!empty($user)){
        return $user->role_id;
    }
    return $role_id;

}
function commission_list(){
    /*return [
        '2.5',
        '4',
        '5',
        '6',
        '7.5',
        '10',
        '15',
    ];*/

    $array = [];

    for ($i=1;$i<=100;$i++)
    {
        array_push($array,$i);
        if ($i == 2) array_push($array,2.5);
        if ($i == 7) array_push($array,7.5);
    }

    return $array;
}
function discount_list(){
    $array = [];
    for ($i=1;$i<=15;$i++){
        array_push($array,$i);
    }
    return $array;
}
function get_symbol_type($type = ""){
    if($type=="member_ship"){
        return "( F )";
    }
    if($type=="discount_code"){
        return "( DS )";
    }
    if($type=="free_service"){
        return "©";
    }
    return "";
}
function get_color_type($type = ""){
    if($type=="member_ship"){
        return "red";
    }
    if($type=="discount_code"){
        return "#1b3ad1";
    }
    if($type=="free_service"){
        return "#93650f";
    }
    return "black";
}
