<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function(Blueprint $table)
        {
            $table->bigIncrements('id');

            $table->string('first_name', 32);
            $table->string('last_name', 32);
            $table->string('email', 100)->unique();
            $table->string('password', 255);
            $table->string('country_code', 255)->default('+971');
            $table->string('phone', 255)->nullable();
            $table->string('image', 255)->nullable();
            $table->tinyInteger('is_active')->default(0);
            $table->bigInteger('role_id')->default(0);
            // required for Laravel 4.1.26
            $table->string('remember_token', 100)->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
