<?php

use Illuminate\Database\Seeder;
use App\User;

class AddBranchIDsToUserUsedWalletSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $users_used_wallets = DB::table('users_used_wallet')
                                ->select('users_used_wallet.id', 'bookings.created_by')
                                ->join('bookings', 'bookings.id', 'users_used_wallet.booking_id')
                                ->whereNull('users_used_wallet.branch_id')
                                ->get();

        foreach ($users_used_wallets as $users_used_wallet)
        {
            if (isset($users_used_wallet->created_by)) $user = User::find($users_used_wallet->created_by);
            
            DB::table('users_used_wallet')->where('id', $users_used_wallet->id)->update(['branch_id' => $user->branch_id ?? 10]);
        }
        
        return 'Done';
    }
}