<div class="modal " ref="create_booking" id="create_booking" tabindex="-1" role="dialog"
     aria-labelledby="createAccountModalLabel" aria-hidden="true"
     data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog modal-lg" role="document">
        <form class="modal-content" method="post">
            <input type="hidden" name="_token" value="{{ csrf_token() }}">
            <div class="modal-header">
                <h5 class="modal-title text-black" id="createAccountModalLabel">{{ __('Create New Booking With Tips') }}</h5>
                <button type="button" class="close" aria-label="Close" data-dismiss="modal">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <div class="modal-body">
            <h4 class="text-center">{{ 'Booking Details' }}</h4>
            @if(\Illuminate\Support\Facades\Auth::user()->role_id==1)
            
                <div class="modal-body">
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Branch</label>
                                <select class="form-control" name="branch_id" id="branch_id">
                                    @if (\Illuminate\Support\Facades\Auth::user()->role_id == 1)
                                        <option value="">All Branches</option>
                                    @endif
                                    {{$branches = \App\Models\Branch::where('id', '>', 0)->get()}} 
                                    @dump($branches);
                                    @if (!empty($branches))
                                        @foreach ($branches as $branch)
                                            @php
                                                $selected = '';
                                                $user_branch_id = \Illuminate\Support\Facades\Auth::user()->branch_id;

                                                if ($branch->id == $user_branch_id) {
                                                    $selected = 'selected="selected"';
                                                }
                                            @endphp
                                            <option {{ $selected }} value="{{ $branch->id }}">{{ $branch->name_en }}</option>
                                        @endforeach
                                    @endif
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Worker</label>
                                <select class="form-control" name="worker_id" id="worker_id">
                                    <option value="">Select a Branch first</option>
                                    <!-- Workers for selected branch will be populated here -->
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="booking_date_time">Booking Date and Time</label>
                                <input type="datetime-local" class="form-control" id="booking_date_time" name="booking_date_time"
                                value="{{ \Carbon\Carbon::now()->format('Y-m-d\TH:i') }}">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="tip">Tips (Between 0 and 200)</label>
                                <input type="number" class="form-control" id="tip" name="tip" min="0" max="200">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Payment Method</label>
                                <select class="form-control" name="payment_type" required>
                                    <option value="">{{ ('Select Payment') }}</option>
                                    @foreach(App\Http\Controllers\Booking\BookingController::get_payment_types() as $index=>$payment_type)
                                        @php
                                            if(in_array($index,['sales_cash_cp','sales_visa_cp','free','sales_cash','sales_visa','wallet','service_cash','service_visa'])){
                                                continue;
                                            }
                                        @endphp
                                        <option value="{{ $index }}">{{ $payment_type }}</option>
                                    @endforeach
                                </select>
                            </div> 
                        </div>
                    </div>
                    <ul class="list-inline pull-right">
                        <!-- Additional elements or buttons can be placed here -->
                    </ul>
                </div>
            

            @else
            <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label>{{ 'Worker' }}</label>
                            <select class="form-control service-select select" name="worker_id">
                                @foreach(\App\Http\Controllers\Booking\BookingController::get_all_workers_for_my_branch() as $worker)
                                    @if(isset($worker) && !empty($worker))
                                        <option value="{{ $worker->id }}">{{ $worker->name }}</option>
                                    @endif
                                @endforeach
                            </select>
                        </div>
                    </div>
                    

                     
                </div>
                <div class="row">
                    
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="tip">Tips (Between 0 and 200)</label>
                            <input type="number" class="form-control" id="tip" name="tip" min="0" max="200">
                        </div>
                    </div>
                </div>   
                <div class="row">
                    <div class="col-md-12">  
                    <div class="form-group">          
                        <label>Payment Method</label>
                        <select class="form-control" name="payment_type" required>
                            <option value="">{{ ('Select Payment') }}</option>
                            @foreach(App\Http\Controllers\Booking\BookingController::get_payment_types() as $index=>$payment_type)
                                
                            @php
                                    if(in_array($index,['sales_cash_cp','sales_visa_cp','free','sales_cash','sales_visa','wallet','service_cash','service_visa'])){
                                    continue;
                                    }
                                @endphp
                                <option value="{{ $index }}">{{ $payment_type }}</option>
                            @endforeach
                        </select>
                    </div> 
                    </div>  
  
                    

                </div>
                <ul class="list-inline pull-right">

                </ul>
            </div>
            @endif  
             
            <div class="modal-footer">
            
            <ul class="list-inline pull-right">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">{{ __('close') }}</button>
               
                
                <li><button type="submit" class="btn btn-success save-booking">{{ __('Create Booking') }}</button></li>

            </ul>
            </div>
        </form>
    </div>
</div>

@push('scripts')
<script>
    $(document).ready(function() {
        $('select[name="branch_id"]').change(function() {
            var selectedBranch = $(this).val();
            var workerDropdown = $('select[name="worker_id"]');
            
            workerDropdown.empty().append('<option value="">Select a Branch first</option>');

            if (selectedBranch !== '') {
                $.ajax({
                    url: '{{ route("get.users.by.branch", ['locale' => app()->getLocale()]) }}',
                    method: 'GET',
                    data: { branch_id: selectedBranch },
                    success: function(response) {
                        workerDropdown.empty().append('<option value="">Select a Worker</option>');
                        $.each(response.users, function(index, user) {
                            workerDropdown.append('<option value="' + user.id + '">' + user.name + '</option>');
                        });
                    },
                    error: function(xhr, status, error) {
                        console.error(error);
                    }
                });
            }
        });

        // Trigger change event on page load if a branch is selected by default
        $('select[name="branch_id"]').trigger('change');
    });
</script>
@endpush
@include('booking.tabs.script')
