@if(isset($contacts) && !$contacts->isEmpty())
    @php
    $count = 0;
    @endphp
    @foreach($contacts as $contact)
        <div class="row @if($count==0) contact-template  @endif">
            <div class="col-md-2">
                <label>{{ __('s.first_name') }}</label>
                <input value="{{ $contact->first_name }}" type="text" name="contact_first_name[]" class="form-control">
            </div>
            <div class="col-md-2">
                <label>{{ __('s.last_name') }}</label>
                <input value="{{ $contact->last_name }}" type="text" name="contact_last_name[]" class="form-control">
            </div>
            <div class="col-md-2">
                <label>{{ __('s.email') }}</label>
                <input value="{{ $contact->email }}" type="email" name="contact_email[]" class="form-control">
            </div>
            <div class="col-md-2">
                <label>{{ __('s.phone') }}</label>
                <input value="{{ $contact->phone }}" type="text" name="contact_phone[]" class="form-control">
            </div>
            <div class="col-md-2">
                <label>{{ __('s.position') }}</label>
                <input value="{{ $contact->position }}" type="text" name="contact_position[]" class="form-control">
            </div>

            @if($count==0)
            <div class="col-md-2">
                <label class="block">&nbsp;</label>
                <a class="btn btn-success btn-sm add-new-contact"><i class="fa fa-plus"></i></a>
            </div>
                @else
                <div class="col-md-2">
                    <label class="block">&nbsp;</label>
                    <a class="btn btn-danger btn-sm remove-contact"><i class="fa fa-close"></i></a>
                </div>
                @endif
        </div>

        @php
            $count++;
        @endphp
        @endforeach

    @else
    <div class="row contact-template">
        <div class="col-md-2">
            <label>{{ __('s.first_name') }}</label>
            <input type="text" name="contact_first_name[]" class="form-control">
        </div>
        <div class="col-md-2">
            <label>{{ __('s.last_name') }}</label>
            <input type="text" name="contact_last_name[]" class="form-control">
        </div>
        <div class="col-md-2">
            <label>{{ __('s.email') }}</label>
            <input type="email" name="contact_email[]" class="form-control">
        </div>
        <div class="col-md-2">
            <label>{{ __('s.phone') }}</label>
            <input type="text" name="contact_phone[]" class="form-control">
        </div>
        <div class="col-md-2">
            <label>{{ __('s.position') }}</label>
            <input type="text" name="contact_position[]" class="form-control">
        </div>
        <div class="col-md-2">
            <label class="block">&nbsp;</label>
            <a class="btn btn-success btn-sm add-new-contact"><i class="fa fa-plus"></i></a>
        </div>
    </div>
    @endif

    <div class="content-contacts"></div>

<!-- script -->
<script type="text/javascript">
    $(document).ready(function(){
        $(document).on("click",".add-new-contact",function(e){
          var self = $(this);
          e.preventDefault();
          var template =  $(".contact-template").clone();
          template.removeClass("contact-template");
          template.find(".btn-success").removeClass("btn-success add-new-contact").addClass("btn-danger remove-contact");
          template.find(".btn-danger").html("<i class='fa fa-close'></i>");
          template.find("input").val('');
          $(".content-contacts").append(template);
        });

        $(document).on("click",".remove-contact",function(e){
          var self = $(this);
          e.preventDefault();
          self.closest(".row").remove();
        });
    });
</script>