@extends('layout')
@section('content')

    <div class="portlet box blue-hoki">
        <div class="portlet-title">
            <div class="caption">
                <i class="fa fa-plus"></i>Tips
            </div>
        </div>
        <div class="portlet-body">
            <div class="row">
                <form method="get" action="{{ set_route('report.tips_reports') }}">
                    <div class="col-md-3">
                        <label>{{ __('Year') }}</label>
                        <select class="form-control select" name="year" required>
                            @if (!empty($years))
                                @foreach ($years as $year)
                                    @php
                                        $selected = '';
                                        if ($year == $selected_year) {
                                            $selected = 'selected=""';
                                        }
                                    @endphp
                                    <option {{ $selected }} value="{{ $year->year }}">{{ $year->year }}</option>
                                @endforeach
                            @endif
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label>{{ __('Month') }}</label>
                        <select class="form-control select" name="month" required>
                            @for ($i = 1; $i <= 12; $i++)
                                @php
                                    $selected = '';
                                    if ($i == $selected_month) {
                                        $selected = 'selected=""';
                                    }
                                @endphp
                                <option {{ $selected }} value="{{ $i }}">
                                    {{ date('F', mktime(0, 0, 0, $i, 10)) }}</option>
                            @endfor
                        </select>
                    </div>
                    
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Branch</label>
                            <select class="form-control" name="branch_id" id="branch_id">
                                @if (get_user_role() == 1 ||get_user_role()==4)
                                    <option value="">All Branches</option>
                                @endif

                                @if (!empty($branches))
                                    @foreach ($branches as $branch)
                                    @php
                                        $selected = '';
                                        $user_branch_id =\Illuminate\Support\Facades\Auth::user()->branch_id;


                                        if ($branch->id == $user_branch_id) {
                                            $selected = 'selected="selected"';
                                        }
                                    @endphp
                                        <option {{ $selected }} value="{{ $branch->id }}">{{ $branch->name_en }}</option>
                                    @endforeach
                                @endif
                            </select>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Worker</label>
                            <select class="form-control" name="worker_id" id="worker_id">
                                <!-- Placeholder option -->
                                <option value="">Select a Branch first</option>
                            </select>
                        </div>
                    </div>
                   

                   

                    <div class="col-md-3">
                        <div class="form-group">
                            <label>&nbsp;</label><br>
                            <button class="btn btn-success">View</button>
                            @if (isset($request) && !empty($request->has('year')))
                                <a target="_blank"
                                href="{{ set_route('report.tips_reports') }}?year={{ $request->get('year') }}&month={{ $request->get('month') }}&branch_id={{ $request->get('branch_id') }}&worker_id={{ $request->get('worker_id') }}&is_pdf=true"
                                class="btn btn-primary">PDF</a>
                                @if($selected_worker)
                                      
                                <a target="_blank"
                                href="{{ set_route('report.tips_reports') }}?year={{ $request->get('year') }}&month={{ $request->get('month') }}&branch_id={{ $request->get('branch_id') }}&worker_id={{ $request->get('worker_id') }}&is_print=true"
                                class="btn btn-primary">Print</a>
                                @endif
                            @endif
                        </div>
                    </div>
                </form>
            </div>
            <div class="row">
                <div class="col-md-12">
                   
                    {!! $template !!}
                </div>
            </div>
        </div>
    </div>


@push('scripts')
    <script type="text/javascript">
        $(document).ready(function() {
            $(".date-format").datetimepicker({
                "format": "DD/MM/Y"
            });
        });
    </script>
@endpush
<script>
    // Assuming you're using jQuery
    $(document).ready(function() {
        $('.print-row').on('click', function(e) {
            e.preventDefault();
            var invoiceUrl = $(this).attr('href');
            printInvoice(invoiceUrl);
        });
        
        function printInvoice(url) {
            var printWindow = window.open(url, '_blank');
            printWindow.onload = function() {
                printWindow.print();
            };
        }
    });
</script>
@push('scripts')
<script>
    $(document).ready(function() {
        $('select[name="branch_id"]').change(function() {
            var selectedBranch = $(this).val();
            var workerDropdown = $('select[name="worker_id"]');
            
            // Clear the worker dropdown except for the placeholder option
            workerDropdown.empty().append('<option value="">Select a Branch first</option>');
            // $user_branch_id =\Illuminate\Support\Facades\Auth::user()->branch_id;

            // If no branch is selected, default to the user's branch ID
             if (selectedBranch === '') {
                selectedBranch = '{{ $selected_branch }}'; // Assuming $user_branch_id holds the user's branch ID
				//here edit user_branch
            }
            
            // Fetch users by branch (including user's branch if no branch is selected)
            $.ajax({
                url: '{{ route("get.users.by.branch", ['locale' => app()->getLocale()]) }}', // Route for fetching users by branch
                method: 'GET',
                data: { branch_id: selectedBranch },
                success: function(response) {
                    $.each(response.users, function(index, user) {
                        workerDropdown.append('<option value="' + user.id + '">' + user.name + '</option>');
                    });
                },
                error: function(xhr, status, error) {
                    console.error(error);
                }
            });
        });

        // Trigger change event on page load if a branch is selected by default
        $('select[name="branch_id"]').trigger('change');
    });
</script>

@endpush


@endsection