@extends('layout')
@section('content')

    <div class="portlet box blue-hoki">
        <div class="portlet-title">
            <div class="caption">
                <i class="fa fa-plus"></i>{{ __('s.roles_list') }}
            </div>
            @if(can('role.create'))
            <a style="margin: 5px 0" href="{{ url('role/create') }}" class="btn btn-success pull-right">
                {{ __('s.create_role') }}
            </a>
                @endif
        </div>
        <div class="portlet-body">
            <table class="table table-bordered table-stripped">
                <thead>
                <tr>
                    <th>#</th>
                    <th>{{__('s.name')}}</th>
                    <th>{{__('s.actions')}}</th>
                </tr>
                </thead>
            </table>
        </div>
    </div>

    <script type="text/javascript">
        $(document).ready(function(){
            $("table").dataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ url('role') }}",
                columns: [
                    {data: 'id', name: 'id'},
                    {data: 'name', name: 'name'},
                    {data: 'action', name: 'action',
                        orderable: false, searchable: false}
                ]
            });
        });
    </script>
@endsection