@extends('layout')

@section('content')



    <form id="create_admin" autocomplete="nope" enctype="multipart/form-data">

        <div class="portlet box blue-hoki">

            <div class="portlet-title">

                <div class="caption">

                    <i class="fa fa-plus"></i>

                    @if(isset($user))

                        {{ __('s.edit_user') }}

                        @else

                        {{ __('s.create_user') }}

                        @endif

                </div>

            </div>

            <div class="portlet-body">

                <input type="hidden" name="_token" value="{{ csrf_token() }}">

                <div class="row">

                    <div class="col-md-2">

                        <label>First name<span class="required">*</span></label>

                        <input required type="text" class="form-control" name="first_name" value="@if(isset($user)){{ $user->first_name }}@endif">

                    </div>

                    <div class="col-md-2">

                        <label>Last name<span class="required">*</span></label>

                        <input required type="text" class="form-control" name="last_name" value="@if(isset($user)){{ $user->last_name }}@endif">

                    </div>

                    <div class="col-md-2">

                        <label>{{__('s.email')}}</label>

                        <input value="@if(isset($user)){{ $user->email }}@endif" autocomplete="nope"  type="email" class="form-control" name="email">

                    </div>

                    <div class="col-md-2">

                        <label>{{ __('s.phone') }}</label>

                        <input value="@if(isset($user)){{ $user->phone }}@endif"  autocomplete="nope"  type="text" class="form-control" name="phone">

                    </div>

                    <div class="col-md-2">

                        <label>Password

                            @if(!isset($user))

                                <span class="required">*</span>

                            @endif

                        </label>

                        <input value="" autocomplete="new-password" @if(!isset($user)) required @endif type="password" class="form-control"

                               name="password">

                    </div>

                    <div class="col-md-2">

                        <label>Confirm Password

                            @if(!isset($user))

                                <span class="required">*</span>

                            @endif

                        </label>

                        <input @if(!isset($user)) required @endif type="password" class="form-control" name="password_confirmation">

                    </div>

                    <div class="col-md-2">

                        <label>{{ __('s.role') }}</label>

                        <select class="form-control" name="role_id" required>

                            @if(!empty($roles))

                                @foreach($roles as $role)

                                    @php

                                    $selected = '';

                                    if(isset($user) && $user->role_id==$role->id){

                                    $selected = 'selected=""';

                                    }

                                    @endphp

                                    <option {{ $selected }} value="{{ $role->id }}">{{ $role->name }}</option>

                                @endforeach

                            @endif

                        </select>

                    </div>

                    <div class="col-md-2">

                        <label>Image</label>

                        <input type="file" name="file">

                        @if(isset($user) && !empty($user->image))

                        <img class="img-thumbnail" src="{{ url(\Storage::url($user->image)) }}">

                            @endif

                    </div>

                </div>

            </div>

            <div class="portlet-footer">

                <button type="submit" class="btn btn-success save">Save</button>&nbsp;&nbsp;

                <a href="{{ url('user') }}" class="btn btn-danger">Cancel</a>

            </div>

        </div>

    </form>



    <!-- script -->

    <script type="text/javascript">

        $(document).ready(function () {

            $(document).on("submit", "#create_admin", function (e) {

                var self = $(this);

                var form_url = "{{ url('user/store') }}";

                @if(isset($user))

                    form_url = "{{ url('user/'.$user->id.'/update') }}";

                @endif

                e.preventDefault();

                self.find(".save").html('Processing...');

                self.find(".save").attr("disabled","disabled");

                $.ajax({

                    "url": form_url,

                    "type": "POST",

                    "dataType": "JSON",

                    data: new FormData(this),

                    contentType: false,

                    cache: false,

                    processData: false,

                    "success": function (data) {

                        if(data.success){

                            window.location = '{{ url('user') }}';

                        }else{

                            self.find(".save").html('Save');

                            self.find(".save").removeAttr("disabled");

                            toastr.error(data.message,toastar_options);

                        }

                    },

                    "error": function () {

                        self.find(".save").html('Save');

                        self.find(".save").removeAttr("disabled");

                    }

                });

            });

        });

    </script>



@endsection