<?php

use Illuminate\Support\Facades\Route;



Route::group(['prefix' => '{locale}', 'where' => ['locale' => '[a-zA-Z]{2}']], function () {

    Route::group(['middleware' => ['setlocale','auth']], function () {

        Route::group(['prefix'=>'account'],function(){

            Route::get('/','Account\AccountController@index')->name('account');

            Route::post('/store','Account\AccountController@store')->name('account.store');

            Route::get('/edit','Account\AccountController@edit')->name('account.edit');

            Route::post('/update','Account\AccountController@update')->name('account.update');

            Route::get('/{id}/delete','Account\AccountController@destroy')->name('account.delete');

            Route::get('/profile','Account\AccountController@profile')->name('account.profile');

            Route::post('/update-profile','Account\AccountController@update_profile')->name('account.profile.update');

        });

    });

});