<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/
//for web
Route::middleware('portal')->group(function() {
    Route::post('/check-email', 'Api\UserController@check_email');
    Route::post('/create-user', 'Api\UserController@create_user');
    Route::get('/get-systems-list', 'Api\UserController@get_systems_list');
    Route::put('/p-change-password','Api\UserController@change_password');
    Route::post('/check-phone-status', 'Api\UserController@check_phone');
});
/*
 * For mobile
 ---------------------
 Auth
 ---------------------
 */
Route::post('/login', 'Api\AuthController@login')->name('mobile.login');
#vendor
Route::post('/vendor-register', 'Api\VendorController@register')->name('mobile.vendor.register');
#user
Route::post('/user-register', 'Api\EndUserController@register')->name('mobile.user.register');
#Forget Password
Route::post('/forget-password', 'Api\EndUserController@forget_password')->name('mobile.forgetPassword');
#Change password
Route::post('/change-password', 'Api\EndUserController@change_password')->name('mobile.changePassword');
#Change password by phone
Route::post('/change-password-by-phone', 'Api\EndUserController@change_password_by_phone')->name('mobile.changePasswordByPhone');
#Check phone
Route::post('/check-phone', 'Api\EndUserController@check_phone')->name('mobile.checkPhone');
#Login by social
Route::post('/login-by-social', 'Api\EndUserController@login_by_social')->name('mobile.loginBySocial');
#profile
Route::put('/update-profile', 'Api\EndUserController@update_profile')->name('mobile.updateProfile');
Route::get('/address/kinds','Api\EndUserController@address_kinds');
Route::get('/address/get','Api\EndUserController@get_address');
Route::post('/address/add','Api\EndUserController@add_address');
Route::post('/address/edit','Api\EndUserController@edit_address');
Route::delete('/address/remove','Api\EndUserController@remove_address');
#end profile
#Dashboard
Route::get('/dashboard', 'Api\DashboardController@index')->name('mobile.dashboard');
Route::get('/trend-products', 'Api\DashboardController@trend_products')->name('mobile.trend_products');
#support
Route::post('/support/add','Api\DashboardController@add_support');
#coupon
Route::post('/get-coupon-value','Api\DashboardController@get_coupon_value');
#checkout
Route::post('/order/checkout','Api\DashboardController@checkout');
#payment
Route::post('/payment/get-rsa','Payment\GetRsa@index');
Route::post('/payment/response-handler','Payment\ResponseHandler@index');

//jwt
/*Route::middleware('jwt.verify')->group(function() {
    Route::post('/logout', 'Api\AuthController@logout');
    Route::get('/user-profile', 'Api\AuthController@userProfile');
    Route::post('/refresh-token', 'Api\AuthController@refresh');
});*/

