<?php

namespace App\Http\Controllers\Booking;


use App\Models\Booking;
use App\Models\BookingDetails;
use App\Models\BookingUserService;
use App\Models\Discount;
use App\Models\MemberShip;
use App\Models\Package;
use App\Models\PackageService;
use App\Models\Service;
use App\Models\Shift;
use App\Models\UserUsedCard;
use App\Models\UserUsedDiscountCode;
use App\Models\UserUsedWallet;
use App\Models\Vacation;
use App\Models\Wallet;
use App\Models\WeekDay;
use App\Models\Worker;
use App\Models\Workerservice;
use App\User;
use DateTime;
use Exception;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;
use DataTables;
use Dompdf\Dompdf;
use Dompdf\Options;
use Illuminate\Support\Facades\Auth;
use PDF;
use Illuminate\Support\Carbon;

class BookingController extends Controller
{

    // public function index_tips(Request $request)
    // {
    //     if ($request->ajax()) {
    //         $data = Booking::select('*')->with('user', 'details');
    //         if (get_user_role() == 2) {
    //             $data->where('branch_id', Auth::user()->branch_id);
    //         }
    //         return Datatables::of($data)
    //             ->addIndexColumn()
    //             ->editColumn('created_by', function ($row) {
    //                 if(isset($row->user))
    //                     return $row->user->first_name . ' ' . $row->user->last_name;
    //                 else return 'Not Found';
    //             })
    //             ->editColumn('mobile', function ($row) {
    //                 return (empty($row->mobile)) ? "" : "+971" . $row->mobile;
    //             })
    //             ->editColumn('payment_type', function ($row) {
    //                 if (!empty($row->payment_type)) {
    //                     return self::get_payment_types($row->payment_type);
    //                 }
    //                 return "";
    //             })
    //             ->editColumn('branch_id', function ($row) {
    //                 if (!empty($row->branch)) {
    //                     return $row->branch->name_en;
    //                 }
    //                 return "";
    //             })
    //             ->addColumn('actions', function ($row) {
    //                 $template = "<a data-id='" . $row->id . "' href='" . set_route('booking.invoice.print_tips') . "?id=" . $row->id . "' target='_blank'  class='btn btn-primary btn-sm print-row'><i class='fa fa-print'></i></a>";
    //                 if (get_user_role() == 1) {
    //                     $template .= "<a data-id='" . $row->id . "' href='" . set_route('booking.delete', ['id' => $row->id]) . "'  class='btn btn-danger btn-xs delete-row'><i class='fa fa-times'></i></a>";
    //                 }
    //                 return $template;
    //             })
    //             ->addColumn('services', function ($row) {
    //                 $template = "";
    //                 if (!$row->details->isEmpty()) {
    //                     foreach ($row->details as $detail) {
    //                         if (isset($detail->service) && !empty($detail->service)) {
    //                             $template .= $detail->service->name_en . "<br>";
    //                         }
    //                     }
    //                 }
    //                 return $template;
    //             })
    //             ->rawColumns(['actions', 'services'])
    //             ->make(true);
    //     }


    //     return view('booking.index_tips');
    // }  

public function index_tips(Request $request)
    {
        if ($request->ajax()) {
            $data = Booking::select('*')->with('user', 'details')->orderBy('created_at', 'desc')->get();;
            if (get_user_role() == 2) {
                $data->where('branch_id', Auth::user()->branch_id);
            }
            return Datatables::of($data)
                ->addIndexColumn()
                ->editColumn('created_by', function ($row) {
                    if(isset($row->user))
                        return $row->user->first_name . ' ' . $row->user->last_name;
                    else return 'Not Found';
                })
                ->editColumn('mobile', function ($row) {
                    return (empty($row->mobile)) ? "" : "+971" . $row->mobile;
                })
                ->editColumn('payment_type', function ($row) {
                    if (!empty($row->payment_type)) {
                        return self::get_payment_types($row->payment_type);
                    }
                    return "";
                })
                ->editColumn('branch_id', function ($row) {
                    if (!empty($row->branch)) {
                        return $row->branch->name_en;
                    }
                    return "";
                })
                ->addColumn('actions', function ($row) {
                    $template = "<a data-id='" . $row->id . "' href='" . set_route('booking.invoice.print_tips') . "?id=" . $row->id . "' target='_blank'  class='btn btn-primary btn-sm print-row'><i class='fa fa-print'></i></a>";
                    if (get_user_role() == 1||get_user_role() == 4) {
                        $template .= "<a data-id='" . $row->id . "' href='" . set_route('booking.delete', ['id' => $row->id]) . "'  class='btn btn-danger btn-xs delete-row'><i class='fa fa-times'></i></a>";
                    }
                    return $template;
                })
                ->addColumn('services', function ($row) {
                    $template = "";
                    if (!$row->details->isEmpty()) {
                        foreach ($row->details as $detail) {
                            if (isset($detail->service) && !empty($detail->service)) {
                                $template .= $detail->service->name_en . "<br>";
                            }
                        }
                    }
                    return $template;
                })
                ->rawColumns(['actions', 'services'])
                ->make(true);
        }



        // $temp_bookings = Booking::where('id','>',0)->orderBy('id','desc');
        // if(get_user_role()==2){
        //     $temp_bookings->where('branch_id',Auth::user()->branch_id);
        // }
        // $bookings = $temp_bookings->get()->count();
        // $bookings_list = $temp_bookings->limit(10)->get();

        // $booking_tips_list = Booking::where('id', '>', 0)
        // ->has('details')
        // ->whereDoesntHave('details', function ($query) {
        //     $query->whereNotNull('service_id');
        // })
        // ->limit(100)
        // ->get();
        
        $temp_bookings = Booking::where('id', '>', 0);

        if (get_user_role() == 2) {
           $temp_bookings->where('branch_id', Auth::user()->branch_id);
        }

        $bookings = $temp_bookings->orderBy('created_at', 'desc')->get()->count();
        $bookings_list = $temp_bookings->orderBy('created_at', 'desc')->limit(10)->get();

        $booking_tips_list = Booking::where('id', '>', 0)
            ->has('details')
            ->whereDoesntHave('details', function ($query) {
                $query->whereNotNull('service_id');
            })
            ->orderBy('created_at', 'desc')
            ->limit(100)
            ->get();


        return view('booking.index_tips',compact('booking_tips_list'));
    }  

    public function index(Request $request)
    {
        if ($request->ajax()) {
            $data = Booking::select('*')->with('user', 'details');
            if (get_user_role() == 2) {
                $data->where('branch_id', Auth::user()->branch_id);
            }
            return Datatables::of($data)
                ->addIndexColumn()
                ->editColumn('created_by', function ($row) {
                    if(isset($row->user))
                        return $row->user->first_name . ' ' . $row->user->last_name;
                    else return 'Not Found';
                })
                ->editColumn('mobile', function ($row) {
                    return (empty($row->mobile)) ? "" : "+971" . $row->mobile;
                })
                ->editColumn('payment_type', function ($row) {
                    if (!empty($row->payment_type))
                    {
                        return self::get_payment_types($row->payment_type);
                    }
                    return "";
                })
                ->editColumn('branch_id', function ($row) {
                    if (!empty($row->branch)) {
                        return $row->branch->name_en;
                    }
                    return "";
                })
                ->addColumn('actions', function ($row) {
                    $template = "<a data-id='" . $row->id . "' href='" . set_route('booking.invoice.print') . "?id=" . $row->id . "' target='_blank'  class='btn btn-primary btn-sm print-row'><i class='fa fa-print'></i></a>";
                    if (get_user_role() == 1||get_user_role() == 4) {
                        $template .= "<a data-id='" . $row->id . "' href='" . set_route('booking.delete', ['id' => $row->id]) . "'  class='btn btn-danger btn-xs delete-row'><i class='fa fa-times'></i></a>";
                    }
                    return $template;
                })
                ->addColumn('services', function ($row) {
                    $template = "";
                    $filteredDetails = $row->details->filter(function ($detail) {
                        return isset($detail->service) && !empty($detail->service->name_en);
                    });
                
                    foreach ($filteredDetails as $detail) {
                        $template .= $detail->service->name_en . "<br>";
                    }
                
                    return $template;
                })
                ->rawColumns(['actions', 'services'])
				
				->filter(function ($query) use ($request) {
					if ($request->has('search') && $request->input('search.value') != '') {
						$keyword = $request->input('search.value');
						
						$query->where(function ($subQuery) use ($keyword) {
							$subQuery->where('full_name', 'like', "%{$keyword}%")
									 ->orWhere('mobile', 'like', "%{$keyword}%")
									 ->orWhere('id', 'like', "%{$keyword}%");

							// Additional columns to be searched
							$subQuery->orWhereHas('user', function ($q) use ($keyword) {
								$q->where('first_name', 'like', "%{$keyword}%")
								  ->orWhere('last_name', 'like', "%{$keyword}%");
							});
							
							$subQuery->orWhereHas('branch', function ($q) use ($keyword) {
								$q->where('name_en', 'like', "%{$keyword}%");
							});
							
							$subQuery->orWhereHas('details.service', function ($q) use ($keyword) {
								$q->where('name_en', 'like', "%{$keyword}%");
							});

							// Handling the mobile number with +971 prefix
							$subQuery->orWhereRaw("CONCAT('+971', mobile) like ?", ["%{$keyword}%"]);
						});
					}
            })

				
                ->make(true);
        }


        return view('booking.index');
    }

    public static function get_all_workers()
    {
        return  Worker::all();
    }
    public static function get_all_workers_for_my_branch()
    {
        return  Worker::where('workers.branch_id', Auth::user()->branch_id)->get();
    }


    public static function get_services()
    {
        return Service::with('workers')->get();
    }
    public static function get_workers_with_services()
    {
        $services = Service::all();
        $result = [];
        if (!empty($services)) {
            foreach ($services as $service) {
                $temp_q = DB::table('workers')
                    ->select('workers.*', 'workers_services.service_id')
                    ->join('workers_services', 'workers.id', '=', 'workers_services.worker_id')
                    ->where('workers_services.service_id', $service->id);
                if (Auth::user()->role_id == 2) {
                    $temp_q->where('workers.branch_id', Auth::user()->branch_id);
                }
                $q = $temp_q->get();
                if (!empty($q)) {
                    foreach ($q as $item) {
                        $temp = [];
                        $temp['id'] = $item->id;
                        $temp['name'] = $item->name;
                        $result[$item->service_id][] = $temp;
                    }
                }
            }
        }
        return $result;
    }
    public  function get_workers(Request $request)
    {
        $service_id = $request->get('service_id');
        $has_data = false;
        $q = DB::table('workers')
            ->select('workers.*')
            ->join('workers_services', 'workers.id', '=', 'workers_services.worker_id')
            ->where('workers_services.service_id', $service_id)
            ->get();
        $template = "<select class='form-control worker-id' name='worker_id[]' multiple>";
        if (!empty($q)) {
            foreach ($q as $item) {
                $template .= "<option value='{$item->id}'>{$item->name}</option>";
            }
        }
        $template .= "</select>";
        if (!$q->isEmpty()) {
            $has_data = true;
        }
        return response()->json(['template' => $template, 'has_data' => $has_data]);
    }
    
    public function getUsersByBranch(Request $request)
    {
        $branchId = $request->input('branch_id');

        // Fetch users based on the provided branch ID
        $users = Worker::where('branch_id', $branchId)->get(['id', 'name']);

        return response()->json(['users' => $users]);
    }
    
    public function get_times(Request $request)
    {
        $get_old_bookings = \App\Models\Booking::where('booking_date', $this->convert_date($request->get('date')))->get();
        $old_times = [];
        if (!empty($get_old_bookings)) {
            foreach ($get_old_bookings as $old_booking) {
                $old_times[$old_booking->worker_id][] = $old_booking->booking_start_time;
            }
        }
        $service_id = $request->get('service_id');
        $worker_id = $request->get('worker_id');
        $date = $this->convert_date($request->get('date'));
        $service = Service::find($service_id);
        $service_duration = $service->max_time;

        $temp_workers = Worker::with('services', 'vacations')->get();
        dd($temp_workers);
        if (!empty($worker_id)) {
            $temp_workers->whereIn('id', $worker_id);
        }
        $temp_workers->whereHas('services', function ($query) use ($service_id) {
            return $query->where('service_id', $service_id);
        });
        $workers = $temp_workers->get();
        //check if worker has vacations and remove if does not has shift
        if (!empty($workers)) {
            foreach ($workers as $index => $worker) {
                $is_remove = false;
                if (!$worker->vacations->isEmpty()) {
                    foreach ($worker->vacations as $vacation) {
                        if ($vacation->day->format('Y-m-d') === $date) {
                            $is_remove = true;
                            break;
                        }
                    }
                }
                if (empty($worker->shift)) {
                    $is_remove = true;
                }
                if ($is_remove) {
                    unset($workers[$index]);
                }
            }
        }
        //get shifts ids
        $shifts_ids = [];
        if (!empty($workers)) {
            foreach ($workers as $worker) {
                if (!in_array($worker->shift_id, $shifts_ids)) {
                    $shifts_ids[$worker->shift_id] = [];
                }
            }
        }
        //add duration to shifts
        if (!empty($shifts_ids)) {
            foreach ($shifts_ids as $shifts_id => $array) {
                $shift = Shift::where('status', '1')->where('id', $shifts_id)->first();
                if (empty($shift)) {
                    unset($shifts_ids[$shifts_id]);
                    continue;
                }
                $start_time = $shift->start_time;
                $end_time = $shift->end_time;
                $break_start = strtotime($shift->break_start);
                $break_end = strtotime($shift->break_end);
                //
                $time = $start_time;
                $time2 = $service_duration;
                $secs = strtotime($time2) - strtotime("00:00:00");
                $result = date("H:i:s", strtotime($time) + $secs);
                $temp['start_time'] = $time->format('H:i:s');
                $temp['end_time'] = $result;
                $shifts_ids[$shifts_id][] = $temp;
                while (strtotime($result) <= strtotime($end_time)) {
                    $time = $result;
                    $time2 = $service_duration;
                    $secs = strtotime($time2) - strtotime("00:00:00");
                    $result = date("H:i:s", strtotime($time) + $secs);
                    $temp['start_time'] = $time;
                    $temp['end_time'] = $result;
                    $is_break = false;
                    if (strtotime($result) > $break_start && strtotime($result) < $break_end) {
                        $is_break = true;
                    }
                    if (!$is_break) {
                        $shifts_ids[$shifts_id][] = $temp;
                    }
                }
            }
        }
        $info = [];
        if (!empty($shifts_ids) && !empty($workers)) {
            foreach ($shifts_ids as $shifts_id => $times) {
                $shift = Shift::where('status', '1')->where('id', $shifts_id)->first();
                if (empty($shift)) {
                    continue;
                }
                $temp_workers = [];
                foreach ($workers as $worker) {
                    if ($worker->shift_id == $shifts_id) {
                        $sub_temp_worker['id'] = $worker->id;
                        $sub_temp_worker['name'] = $worker->name;
                        $temp_workers[] = $sub_temp_worker;
                    }
                }
                $info[$shifts_id]['workers'] = $temp_workers;
                $info[$shifts_id]['times'] = $times;
                $info[$shifts_id]['shift'] = $shift->name;
            }
        }
        //remove from old times
        if (!empty($old_times) && !empty($info)) {
            foreach ($old_times as $worker_id => $old_time) {
                foreach ($info as $shift_id => $item) {
                    $has_worker = false;
                    if (isset($item['workers']) && !empty($item['workers'])) {
                        foreach ($item['workers'] as $worker) {
                            if ($worker['id'] == $worker_id) {
                                $has_worker = true;
                            }
                        }
                    }
                    if ($has_worker) {
                        if (isset($item['times']) && !empty($item['times'])) {
                            foreach ($item['times'] as $index => $start_date) {
                                if (in_array($start_date['start_time'], $old_time)) {
                                    unset($info[$shift_id]['times'][$index]);
                                }
                            }
                        }
                    }
                }
            }
        }
        $template = (string)view('booking.template.index', compact('info'));
        return response()->json(['template' => $template]);
    }
    public function convert_date($date, $format = "d/m/Y")
    {
        $temp = DateTime::createFromFormat($format, $date);
        return $temp->format('Y-m-d');
    }
    // public function save_bookings(Request $request)
    // {
    //     $discount_amount = 0;
    //     $discount_type = "";
    //     $discount_code = "";
    //     $user_id = 0;
    //     if (isset($request->discount_code) && !empty($request->discount_code))
    //     {
    //         $all_discount = self::get_discount_codes();
    //         $has_error = true;
    //         $discount = Discount::find($request->discount_code);
    //         if (!empty($all_discount)) 
    //         {
    //             foreach ($all_discount as $item) 
    //             {
    //                 if ($item['id'] == $request->discount_code)
    //                 {
    //                     $has_error = false;
    //                     break;
    //                 }
    //             }
    //         }
    //         if ($has_error || empty($discount)) return response()->json(['success' => false, 'message' => 'Discount code not valid']);
            
    //         $get_user = User::where('phone', $request->get('mobile'))->first();
    //         if (!empty($get_user)) $user_id = $get_user->id;

    //         $discount_amount = $discount->amount;
    //         $discount_type = $discount->type;
    //         $discount_code = $discount->code;
    //     }
    //     //card
    //     $card_amount = 0;
    //     $card_code = "";
    //     if (isset($request->card) && !empty($request->card)) 
    //     {
    //         $card = MemberShip::where('id', $request->card)
    //             ->whereRaw('status="Active"')
    //             ->whereRaw("'" . date('Y-m-d') . "' >= STR_TO_DATE( start_at , '%d/%m/%Y' )  and '" . date('Y-m-d') . "' <= STR_TO_DATE( end_at , '%d/%m/%Y' )")
    //             ->first();
    //         if (empty($card)) return response()->json(['success' => false, 'message' => 'Member Ship Card not valid']);
        
    //         $get_user = User::where('phone', $request->get('mobile'))->first();
    //         if (!empty($get_user)) $user_id = $get_user->id;

    //         $card_amount = $card->percent;
    //         $card_code = $card->membership_no;
    //     }
    //     $wallet_id = Null;
    //     $service_price = 0;
    //     $service_id = $request->get('service_id');
    //     if (isset($service_id) && !empty($service_id))
    //     {
    //         foreach ($service_id as $item) {
    //             $service = Service::find($item);
    //             if (!empty($service)) {
    //                 $service_price += $service->price;
    //             }
    //         }
    //     }
    //     $avaliable_wallet = 0;
    //     if (isset($request->wallet) && !empty($request->wallet) && !empty($service)) {
    //         $wallet = Wallet::find($request->wallet);
    //         if (!empty($wallet)) {
    //             $get_user = User::where('phone', $request->get('mobile'))->first();
    //             if (!empty($get_user)) {
    //                 $user_id = $get_user->id;
    //                 $get_used_wallet = UserUsedWallet::where('user_id', $get_user->id)
    //                     ->where('wallet_id', $request->get('wallet'))
    //                     ->where('branch_id', Auth::user()->branch_id)
    //                     ->get();
    //                 $total_used_wallet = 0;
    //                 if (!empty($get_used_wallet)) {
    //                     foreach ($get_used_wallet as $used_wallet) {
    //                         $total_used_wallet += $used_wallet->amount;
    //                     }
    //                 }
    //                 $avaliable_wallet = $wallet->amount - $total_used_wallet;
    //                 $wallet_id = $wallet->id;
    //                 if ($avaliable_wallet < $service_price) {
    //                     return response()->json(['success' => false, 'message' => 'There is not enough balance in your wallet']);
    //                 }
    //             }
    //         }
    //     }
    //     //check mobile
    //     $mobile = $request->get('mobile');
    //     if (!empty($mobile)) 
    //     {
    //         $mobile = substr($mobile, 0, 1);
    //         if ($mobile == 0 || $mobile == "") return response()->json(['success' => false, 'message' => 'Mobile must be not start with zero']);
    //     }

    //     $created_by = Auth::id();
    //     $data['booking_date'] = $this->convert_date(date('d/m/Y'));
    //     $data['wallet_id'] = $wallet_id;
    //     $data['full_name'] = $request->get('full_name');
    //     $data['mobile'] = $request->get('mobile');
    //     $data['notes'] = $request->get('notes');
    //     $data['payment_type'] = $request->get('payment_type');
    //     $data['created_by'] = $created_by;
    //     $data['branch_id'] = Auth::user()->branch_id;
    //     $free_service = $this->get_free_service($request);
    //     //create booking
    //     return DB::transaction(function () use ($request, $data, $discount_code, $discount_amount, $discount_type, $user_id, $card_code, $card_amount, $service_price, $wallet_id, $avaliable_wallet, $free_service) {
    //         //save booking
    //         $booking_user_id = Null;
    //         $user = User::where('phone', $request->get('mobile'))->first();
    //         if (!empty($user)) {
    //             $booking_user_id = $user->id;
    //         }
    //         $data['user_id'] = $booking_user_id;
    //         $booking = \App\Models\Booking::create($data);
    //         if (!empty($wallet_id)) {
    //             $user = User::find($user_id);
    //             UserUsedWallet::create([
    //                 'user_id' => $user_id,
    //                 'wallet_id' => $wallet_id,
    //                 'amount' => $service_price,
    //                 'booking_id' => $booking->id,
    //                 'branch_id' => Auth::user()->branch_id
    //             ]);
    //             //update user wallet
    //             if (!empty($user)) {
    //                 $user->wallet -= $service_price;
    //                 $user->save();
    //             }
    //             $new_wallet = 0;
    //             $user_detail = User::find($user_id);
    //             if (!empty($user_detail)) {
    //                 $new_wallet = $user_detail->wallet;
    //             }
    //             //update set wallet to used
    //             Wallet::where('id', $wallet_id)->update([
    //                 'used' => 1
    //             ]);
    //             $this->send_wallet_message("+971" . $request->get('mobile'), $service_price, $new_wallet);
    //         } else {
    //             $this->send_message("+971" . $request->get('mobile'));
    //         }
    //         $Booking_date =$request->get( 'booking_date' );
    //         if (empty($Booking_date) && Auth::user()->role_id==2 )
    //          { $Booking_date = Carbon::now();}
    //         //save services
    //         if (isset($request->service_id) && !empty($request->get('service_id'))) {
    //             foreach ($request->get('service_id') as $index => $service_id) {
    //                 $get_booked_free_service = $this->get_booked_free_service($request, $service_id);
    //                 $service = Service::find($service_id);
    //                 $is_free = 0;
    //                 $price = $service->price;
    //                 if ($service_id == $free_service) {
    //                     $is_free = 1;
    //                 }
    //                 if ($get_booked_free_service == 1 && $is_free == 0) {
    //                     $is_free = 1;
    //                 }
    //                 if (!empty($service)) 
    //                 {
    //                     $commission = 0;
    //                     if ((isset($request->commission[$index])) && in_array($request->commission[$index], commission_list())) {
    //                         $commission = $request->commission[$index];
    //                     }
    //                     BookingDetails::create([
    //                         'is_free' => $is_free,
    //                         'booking_id' => $booking->id,
    //                         'service_id' => $service_id,
    //                         'price' => $price,
    //                         'from_time' => (isset($request->from[$index])) ? $request->from[$index] : '',
    //                         'to_time' => (isset($request->to[$index])) ? $request->to[$index] : '',
    //                         '_date' => (isset($request->date[$index])) ? $request->date[$index] : '',
    //                         'worker_id' => (isset($request->worker_id[$index])) ? $request->worker_id[$index] : '',
    //                         'user_id' => $booking_user_id,
    //                         'commission' => $commission
    //                     ]);
    //                 }


    //             }
    //         }

    //         else 
    //         {

    //             // $service = Service::where('name_en', 'Various')->first();
    //             // $serv_id= $service->id;
    //             // print(serv_id);
    //             BookingDetails::create([
    //                 'is_free' =>  NULL,
    //                 'booking_id' => $booking->id,
    //                 'service_id' =>NULL,
    //                 'price' => 0,
    //                 'from_time' => NULL,
    //                 'to_time' => NULL,
    //                 '_date' =>$Booking_date,
    //                 'worker_id' => $request->get('worker_id'),
    //                 'user_id' => $booking_user_id,
    //                 'tip' => $request->tip,
    //             ]);  
    //         }
    //         //for discount code
    //         if (isset($request->discount_code) && !empty($request->discount_code)) {
    //             UserUsedDiscountCode::create([
    //                 'user_id' => $user_id,
    //                 'discountcode_id' => $request->discount_code,
    //                 'code' => $discount_code,
    //                 'amount' => $discount_amount,
    //                 'type' => $discount_type,
    //                 'booking_id' => $booking->id
    //             ]);
    //         }
    //         //for card
    //         if (isset($request->card) && !empty($request->card)) {
    //             UserUsedCard::create([
    //                 'user_id' => $user_id,
    //                 'membershipcards_id' => $request->card,
    //                 'code' => $card_code,
    //                 'amount' => $card_amount,
    //                 'booking_id' => $booking->id
    //             ]);
    //         }
    //         return response()->json(['success' => true]);
    //     });
    // }
    
    public function save_bookings(Request $request)
    {   if ($request->get('branch_id') != NULL)
        $branch_id = $request->get('branch_id');
        else $branch_id = Auth::user()->branch_id ;
        $discount_amount = 0;
        $discount_type = "";
        $discount_code = "";
        $user_id = 0;
        if (isset($request->discount_code) && !empty($request->discount_code))
        {
            $all_discount = self::get_discount_codes();
            $has_error = true;
            $discount = Discount::find($request->discount_code);
            if (!empty($all_discount)) 
            {
                foreach ($all_discount as $item) 
                {
                    if ($item['id'] == $request->discount_code)
                    {
                        $has_error = false;
                        break;
                    }
                }
            }
            if ($has_error || empty($discount)) return response()->json(['success' => false, 'message' => 'Discount code not valid']);
            
            $get_user = User::where('phone', $request->get('mobile'))->first();
            if (!empty($get_user)) $user_id = $get_user->id;

            $discount_amount = $discount->amount;
            $discount_type = $discount->type;
            $discount_code = $discount->code;
        }
        //card
        $card_amount = 0;
        $card_code = "";
        if (isset($request->card) && !empty($request->card)) 
        {
            $card = MemberShip::where('id', $request->card)
                ->whereRaw('status="Active"')
                ->whereRaw("'" . date('Y-m-d') . "' >= STR_TO_DATE( start_at , '%d/%m/%Y' )  and '" . date('Y-m-d') . "' <= STR_TO_DATE( end_at , '%d/%m/%Y' )")
                ->first();
            if (empty($card)) return response()->json(['success' => false, 'message' => 'Member Ship Card not valid']);
        
            $get_user = User::where('phone', $request->get('mobile'))->first();
            if (!empty($get_user)) $user_id = $get_user->id;

            $card_amount = $card->percent;
            $card_code = $card->membership_no;
        }
        $wallet_id = Null;
        $service_price = 0;
        $service_id = $request->get('service_id');
        if (isset($service_id) && !empty($service_id))
        {
            foreach ($service_id as $item) {
                $service = Service::find($item);
                if (!empty($service)) {
                    $service_price += $service->price;
                }
            }
        }
        $avaliable_wallet = 0;
        if (isset($request->wallet) && !empty($request->wallet) && !empty($service)) {
            $wallet = Wallet::find($request->wallet);
            if (!empty($wallet)) {
                $get_user = User::where('phone', $request->get('mobile'))->first();
                if (!empty($get_user)) {
                    $user_id = $get_user->id;
                    $get_used_wallet = UserUsedWallet::where('user_id', $get_user->id)
                        ->where('wallet_id', $request->get('wallet'))
                        ->where('branch_id', Auth::user()->branch_id)
                        ->get();
                    $total_used_wallet = 0;
                    if (!empty($get_used_wallet)) {
                        foreach ($get_used_wallet as $used_wallet) {
                            $total_used_wallet += $used_wallet->amount;
                        }
                    }
                    $avaliable_wallet = $wallet->amount - $total_used_wallet;
                    $wallet_id = $wallet->id;
                    if ($avaliable_wallet < $service_price) {
                        return response()->json(['success' => false, 'message' => 'There is not enough balance in your wallet']);
                    }
                }
            }
        }
        //check mobile
        $mobile = $request->get('mobile');
        if (!empty($mobile)) 
        {
            $mobile = substr($mobile, 0, 1);
            if ($mobile == 0 || $mobile == "") return response()->json(['success' => false, 'message' => 'Mobile must be not start with zero']);
        }

        $created_by = Auth::id();
        $data['booking_date'] = $this->convert_date(date('d/m/Y'));
        $data['wallet_id'] = $wallet_id;
        $data['full_name'] = $request->get('full_name');
        $data['mobile'] = $request->get('mobile');
        $data['notes'] = $request->get('notes');
        $data['payment_type'] = $request->get('payment_type');
        $data['created_by'] = $created_by;
        $data['branch_id'] = $branch_id;
        //$free_service = $this->get_free_service($request);
		$free_service2 = $this->get_free_services2($request);
        //create booking
        return DB::transaction(function () use ($request, $data, $discount_code, $discount_amount, $discount_type, $user_id, $card_code, $card_amount, $service_price, $wallet_id, $avaliable_wallet,$free_service2) {
            //save booking
            $booking_user_id = Null;
            $user = User::where('phone', $request->get('mobile'))->first();
           
		   if (!empty($user)) {
                $booking_user_id = $user->id;
            }
            $data['user_id'] = $booking_user_id;
            $booking = \App\Models\Booking::create($data);
            if (!empty($wallet_id)) {
                $user = User::find($user_id);
                UserUsedWallet::create([
                    'user_id' => $user_id,
                    'wallet_id' => $wallet_id,
                    'amount' => $service_price,
                    'booking_id' => $booking->id,
                    'branch_id' => Auth::user()->branch_id,
                ]);
                //update user wallet
                if (!empty($user)) {
                    $user->wallet -= $service_price;
                    $user->save();
                }
                $new_wallet = 0;
                $user_detail = User::find($user_id);
                if (!empty($user_detail)) {
                    $new_wallet = $user_detail->wallet;
                }
                //update set wallet to used
                Wallet::where('id', $wallet_id)->update([
                    'used' => 1
                ]);
                $this->send_wallet_message("+971" . $request->get('mobile'), $service_price, $new_wallet);
            } else {
                $this->send_message("+971" . $request->get('mobile'));
            }
            $Booking_date =$request->get( 'booking_date' );
            // if (empty($Booking_date) && Auth::user()->role_id==2 )
            //  { $Booking_date = Carbon::now();}
              if (empty($Booking_date) )
             { $Booking_date = Carbon::now();}
            //save services
            if (isset($request->service_id) && !empty($request->get('service_id'))) {
                foreach ($request->get('service_id') as $index => $service_id) {
                    $service = Service::find($service_id);
                    $is_free = 0;
                    $price = $service->price;
					
				 if(!empty($free_service2)){
					foreach ($free_service2 as $index => $free) {
						if ($service_id == $free) {
							$is_free = 1;
						}
                       }
				    }

 
					
                    if (!empty($service)) 
                    {
                        $commission = 0;
                        if ((isset($request->commission[$index])) && in_array($request->commission[$index], commission_list())) {
                            $commission = $request->commission[$index];
                        }
                        BookingDetails::create([
                            'is_free' => $is_free,
                            'booking_id' => $booking->id,
                            'service_id' => $service_id,
                            'price' => $price,
                            'from_time' => (isset($request->from[$index])) ? $request->from[$index] : '',
                            'to_time' => (isset($request->to[$index])) ? $request->to[$index] : '',
                            '_date' => (isset($request->date[$index])) ? $request->date[$index] : '',
                            'worker_id' => (isset($request->worker_id[$index])) ? $request->worker_id[$index] : '',
                            'user_id' => $booking_user_id,
                            'commission' => $commission
                        ]);
                    }


                }
            }

            else 
            {

                // $service = Service::where('name_en', 'Various')->first();
                // $serv_id= $service->id;
                // print(serv_id);
                BookingDetails::create([
                    'is_free' =>  NULL,
                    'booking_id' => $booking->id,
                    'service_id' =>NULL,
                    'price' => 0,
                    'from_time' => NULL,
                    'to_time' => NULL,
                    '_date' =>$Booking_date,
                    'worker_id' => $request->get('worker_id'),
                    'user_id' => $booking_user_id,
                    'tip' => $request->tip,
                ]);  
            }
            //for discount code
            if (isset($request->discount_code) && !empty($request->discount_code)) {
                UserUsedDiscountCode::create([
                    'user_id' => $user_id,
                    'discountcode_id' => $request->discount_code,
                    'code' => $discount_code,
                    'amount' => $discount_amount,
                    'type' => $discount_type,
                    'booking_id' => $booking->id
                ]);
            }
            //for card
            if (isset($request->card) && !empty($request->card)) {
                UserUsedCard::create([
                    'user_id' => $user_id,
                    'membershipcards_id' => $request->card,
                    'code' => $card_code,
                    'amount' => $card_amount,
                    'booking_id' => $booking->id
                ]);
            }
            return response()->json(['success' => true]);
			
        });
    }


    public function editDate(Request $request)
    { 
        //   print($request->route('id')) ; 
        $item = Booking::findOrFail($request->route('id'));
        // return $item ;
        // dd( $item->id);
        return view('booking.editTipsDate', compact('item'));
    }
    
        public function updateBookingDate(Request $request)
        {
            $itemId = $request->input('item_id');
            $editedDate = $request->input('edited_date');
    
            // Retrieve and update the booking record with the new date
            $booking = Booking::find($itemId);
            if ($booking) {
                $booking->date = $editedDate; // Replace 'date' with your actual column name
                $booking->save();
    
                return response()->json(['message' => 'Date updated successfully']);
            }
    
            return response()->json(['error' => 'Booking not found'], 404);
        }
    
        public function updateDate(Request $request)
    {
        $itemId = $request->input('id');
        $editedDate = $request->input('edited_date');
    
        // Find the booking by ID
        $booking = Booking::findOrFail($itemId);
    
        // Update the date field in the database
        $booking->details->first()->update([
            '_date' => $editedDate
        ]);
    
        // Optionally, you can return a response if needed
        return response()->json(['message' => 'Date updated successfully']);
    }


    public function send_wallet_message($phone_number, $cut_amount, $new_balance)
    {
        if (!empty($phone_number)) {
            $curl = curl_init();

            curl_setopt_array($curl, [
                CURLOPT_URL => "https://api.msg91.com/api/v5/flow/",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "POST",
                CURLOPT_POSTFIELDS => "{\n  \"flow_id\": \"62588c3d0a59d21b56335d52\",\n  \"sender\": \"meenscare\",\n  \"mobiles\": \"$phone_number\",\n  \"cut_amount\": \"$cut_amount\",\n  \"new_balance\": \"$new_balance\"\n}",
                CURLOPT_HTTPHEADER => [
                    "authkey: 375120AZqrW6qQU62443145P1",
                    "content-type: application/JSON"
                ],
            ]);

            $response = curl_exec($curl);
            $err = curl_error($curl);

            curl_close($curl);
        }
    }

    public function send_message($phone_number)
    {
        if (!empty($phone_number)) {
            $curl = curl_init();
            curl_setopt_array($curl, [
                CURLOPT_URL => "https://api.msg91.com/api/v5/flow/",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "POST",
                CURLOPT_POSTFIELDS => "{\n  \"flow_id\": \"625f36beaee57b64d16e2ec1\",\n  \"sender\": \"meenscare\",\n  \"mobiles\": \"$phone_number\"\n}",
                CURLOPT_HTTPHEADER => [
                    "authkey: 375120AZqrW6qQU62443145P1",
                    "content-type: application/JSON"
                ],
            ]);

            $response = curl_exec($curl);
            $err = curl_error($curl);

            curl_close($curl);
        }
    }
    

    public function getDataTable_tips(Request $request)
    {
        dd('sss');
        $data = \App\Models\Booking::select('*');
        $data->with('user', 'details');
        return Datatables::of($data)
            ->addIndexColumn()
            ->editColumn('created_by', function ($row) {
                if (isset($row->user))
                    return $row->user->first_name ?? ''. ' ' . $row->user->last_name ?? '';
            })
            ->editColumn('payment_type', function ($row) {
                if (!empty($row->payment_type)) {
                    return self::get_payment_types($row->payment_type);
                }
                return "";
            })
            ->addColumn('actions', function ($row) {

                $template = "<a data-id='" . $row->id . "' target='_blank' href='" . set_route('booking.invoice.print_tips') . "' class='btn btn-primary btn-sm print-row'><i class='fa fa-print'></i></a>";
                return $template;
            })
            ->addColumn('services', function ($row) {
                $template = "";
                if (!$row->details->isEmpty()) {
                    foreach ($row->details as $detail) {
                        if (isset($detail->service) && !empty($detail->service)) {
                            $template .= $detail->service->trans[0]->name . "<br>";
                        }
                    }
                }
                return $template;
            })
            ->rawColumns(['actions', 'services'])
            ->make(true);
    }


    public function getDataTable(Request $request)
    {
        dd('sss');
        $data = \App\Models\Booking::select('*');
        $data->with('user', 'details');
        return Datatables::of($data)
            ->addIndexColumn()
            ->editColumn('created_by', function ($row) {
                if (isset($row->user))
                    return $row->user->first_name ?? ''. ' ' . $row->user->last_name ?? '';
            })
            ->editColumn('payment_type', function ($row) {
                if (!empty($row->payment_type)) {
                    return self::get_payment_types($row->payment_type);
                }
                return "";
            })
            ->addColumn('actions', function ($row) {

                $template = "<a data-id='" . $row->id . "' target='_blank' href='" . set_route('booking.invoice.print') . "' class='btn btn-primary btn-sm print-row'><i class='fa fa-print'></i></a>";
                return $template;
            })
            ->addColumn('services', function ($row) {
                $template = "";
                if (!$row->details->isEmpty()) {
                    foreach ($row->details as $detail) {
                        if (isset($detail->service) && !empty($detail->service)) {
                            $template .= $detail->service->trans[0]->name . "<br>";
                        }
                    }
                }
                return $template;
            })
            ->rawColumns(['actions', 'services'])
            ->make(true);
    }
    public static function get_payment_types($type = "")
    {
        $result =  [
            'service_cash' => 'Service Cash',
            'service_visa' => 'Service Visa',
            'sales_cash' => 'Sales Cash',
            'sales_visa' => 'Sales Visa',
            'sales_cash_cp' => 'Sales Cash(CP)',
            'sales_visa_cp' => 'Sales Visa(CP)',
            'free' => 'Free',
            'wallet' => 'Coupon',
            'tips_visa' => 'Tips Visa',
        ];
        if (!empty($type)) {
            return (isset($result[$type])) ? $result[$type] : '';
        }
        return $result;
    }
    public static function get_payment_status($status = "")
    {
        $result = [
            'un_paid' => 'Un-paid',
            'paid' => 'Paid'
        ];
        if (!empty($status)) {
            return (isset($result[$status])) ? $result[$status] : '';
        }
        return $result;
    }


    public function print_invoice(Request $request)
    {
        $id = $request->get('id');
        $result = Booking::where("id", $id)->with("user")->first();
        if (Auth::user()->role_id == 2) {
            if ($result->branch_id != Auth::user()->branch_id) {
                dd("No");
            }
        }
        $pdf = new Dompdf();
        $pdf->setPaper(array(0, 0, 226, 800));
        $GLOBALS['bodyHeight'] = 0;
        $pdf->setCallbacks(
            array(
                'myCallbacks' => array(
                    'event' => 'end_frame', 'f' => function ($infos) {
                        $frame = $infos["frame"];
                        if (strtolower($frame->get_node()->nodeName) === "body") {
                            $padding_box = $frame->get_padding_box();
                            $GLOBALS['bodyHeight'] += $padding_box['h'];
                        }
                    }
                )
            )
        );
        $pdf->loadHtml(view('booking.invoice', compact('result'))->render());
        $pdf->render();
        unset($pdf);
        $pdf = PDF::loadView('booking.invoice', compact('result'));
        // $pdf->dompdf->set_option('dpi' , '512');
        $pdf->setPaper(array(0, 0, 226, $GLOBALS['bodyHeight'] + 50));
        return $pdf->stream('pdfview.pdf');
    }

    public function print_invoice_tips(Request $request)
    {
        $id = $request->get('id');
        $result = Booking::where("id", $id)->with("user")->first();
        if (Auth::user()->role_id == 2) {
            if ($result->branch_id != Auth::user()->branch_id) {
                dd("No");
            }
        }
        $pdf = new Dompdf();
        $pdf->setPaper(array(0, 0, 226, 800));
        $GLOBALS['bodyHeight'] = 0;
        $pdf->setCallbacks(
            array(
                'myCallbacks' => array(
                    'event' => 'end_frame', 'f' => function ($infos) {
                        $frame = $infos["frame"];
                        if (strtolower($frame->get_node()->nodeName) === "body") {
                            $padding_box = $frame->get_padding_box();
                            $GLOBALS['bodyHeight'] += $padding_box['h'];
                        }
                    }
                )
            )
        );
        $pdf->loadHtml(view('booking.invoice', compact('result'))->render());
        $pdf->render();
        unset($pdf);
        $pdf = PDF::loadView('booking.invoice', compact('result'));
        // $pdf->dompdf->set_option('dpi' , '512');
        $pdf->setPaper(array(0, 0, 226, $GLOBALS['bodyHeight'] + 50));
        return $pdf->stream('pdfview.pdf');
    }


    public function get_wallet(Request $request)
    {
        $result = [];
        $discount_codes = [];
        $cards = [];
        $user_services_view = [];
        $get_user = User::where('phone', $request->get('mobile'))->first();
        if (!empty($get_user)) 
        {
            $get_wallet = $get_user->wallet_list;
            
            if (!$get_wallet->isEmpty() && isset(Auth::user()->branch_id)) 
            {
                foreach ($get_wallet as $item) 
                {
                    if ($item->branch_id == Auth::user()->branch_id)
                    {
                        if (strtotime(date('Y-m-d')) >= strtotime($this->convert_date($item->wallet->start_at)) && strtotime(date('Y-m-d'))  <= strtotime($this->convert_date($item->wallet->end_at)))
                        {
                            //get used wallet
                            $get_used_wallet = UserUsedWallet::where('user_id', $get_user->id)
                                ->where('wallet_id', $item->wallet_id)
                                //->where('branch_id', Auth::user()->branch_id)
                                ->get();
                                
                            $used_wallet_amount = 0;
                            if (!empty($get_used_wallet)) 
                            {
                                foreach ($get_used_wallet as $get_us_ww) {
                                    $used_wallet_amount += $get_us_ww->amount;
                                }
                            }
                            
                            $temp = [];
                            $temp['wallet_id'] = $item->wallet_id;
                            $temp['code'] = $item->wallet->code;
                            $temp['amount'] = $item->amount - $used_wallet_amount;
                            array_push($result, $temp);
                        }
                    }
                }
            }
            $cards = $this->get_membershipcards($get_user->id);
            
            if (isset($request->discount_code) && !empty($request->discount_code))
            {
                $all_discount = self::get_discount_codes();
                $has_error = true;
                $discount = Discount::find($request->discount_code);
            }

            $all_user_services = BookingUserService::select('services.id', 'name_en','service_count')
                                    ->join('users', 'users.id', 'bookings_users_services.user_id')
                                    ->join('services', 'services.id', 'bookings_users_services.service_id')
                                    ->where('bookings_users_services.user_id', $get_user->id)
                                    ->get();
                
            /*return $all_user_services = BookingUserService::select('services.id', 'services.name_en', 'bookings_users_services.service_count')
                                    ->join('services', 'services.id', 'bookings_users_services.service_id')
                                    ->join('bookings_details', 'bookings_details.service_id', 'bookings_users_services.service_id')
                                    ->whereNotIn('bookings_details.booking_id', function ($query) {
                                        $query->select('booking_id')->from('users_used_cards')
                                            ->where('users_used_cards.user_id', 'bookings_users_services.user_id');
                                    })
                                    ->whereNotIn('bookings_details.booking_id', function ($query) {
                                        $query->select('booking_id')->from('users_used_discount')
                                            ->where('users_used_discount.user_id', 'bookings_users_services.user_id');
                                    })
                                    ->whereNotIn('bookings_details.booking_id', function ($query) {
                                        $query->select('booking_id')->from('users_used_wallet')
                                            ->where('users_used_wallet.user_id', 'bookings_users_services.user_id');
                                    })
                                    ->where('bookings_users_services.user_id', $get_user->id)
                                    ->Distinct('services.id')
                                    ->get();
*/


/*SELECT distinct bookings.id FROM `bookings_details` , bookings, bookings_users_services
WHERE bookings_details.service_id = bookings_users_services.service_id 
and bookings.id = bookings_details.booking_id and bookings.user_id = bookings.user_id
and bookings_users_services.user_id = 5
and `bookings_details`.`booking_id` not in (select `booking_id` from `users_used_cards` where `users_used_cards`.`user_id` = bookings_users_services.user_id)
and `bookings_details`.`booking_id` not in (select `booking_id` from `users_used_discount` where `users_used_discount`.`user_id` = bookings_users_services.user_id)
and `bookings_details`.`booking_id` not in (select `booking_id` from `users_used_wallet` where `users_used_wallet`.`user_id` = bookings_users_services.user_id)
and bookings.deleted_at is null and bookings.payment_type in ('service_visa', 'service_cash')*/

            $user_services = [];
            $used_selected_services = [];
            $used_selected_service_IDs = [];
            $is_free = 0;
            
            foreach ($all_user_services as $all_user_service) 
            {
                if (in_array($all_user_service->id, $request->selected_services))
                {
                    array_push($used_selected_services, $all_user_service);
                    array_push($used_selected_service_IDs, $all_user_service->id);
                }
                else {
                    array_push($user_services, $all_user_service);
                }
            }
            
            $not_used_selected_services = Service::select('services.id', 'name_en')
                                                ->whereIn('id', $request->selected_services)
                                                ->whereNotIn('id', $used_selected_service_IDs)
                                                ->get();
        
            if(isset($discount->amount))
            {
                if ($discount->amount == 100.00) $is_free = 1;
            }

            $user_services_view = (string)view('booking.services', compact('user_services', 'used_selected_services', 'is_free', 'not_used_selected_services'));
        }
        $view = (string)view('booking.wallet', compact('result', 'discount_codes', 'cards', 'user_services_view'));
        return response()->json(['view' => $view, 'user_services_view' => $user_services_view, "user"=>$get_user]);
    }

    public function get_booking_services(Request $request)
    {
        $user_services = [];
        $user = User::where('phone', $request->get('mobile'))->first();
        
        if (isset($user)) 
        {
            $user_services = BookingUserService::select('name_en','service_count')
                                ->join('users', 'id', 'bookings_users_services.user_id')
                                ->join('services', 'id', 'bookings_users_services.service')
                                ->where('bookings_users_services.user_id', $user->id)
                                ->get();
        }
        $view = (string)view('booking.services', compact('user_services'));
        return response()->json(['view' => $view, "user" => $user]);
    }
    
    public static function get_discount_codes()
    {
        $result = [];
        $discount_codes = Discount::where('status', 'Active')
            ->whereRaw("'" . date('Y-m-d') . "' >= STR_TO_DATE( start_at , '%d/%m/%Y' ) and '" . date('Y-m-d') . "' <= STR_TO_DATE( end_at , '%d/%m/%Y' )")
            ->get();
        if (!empty($discount_codes)) {
            foreach ($discount_codes as $discount_code) {
                $has_error = false;
                $get_old_codes = UserUsedDiscountCode::where('discountcode_id', $discount_code->id)->get();
                if ($discount_code->using_type == "single") {
                    if (!$get_old_codes->isEmpty()) {
                        $has_error = true;
                    }
                }
                if ($discount_code->using_type == "multi") {
                    $get_old_codes_count = count($get_old_codes);
                    if ($get_old_codes_count >= $discount_code->benefit_numbers) {
                        $has_error = true;
                    }
                }
                if ($has_error) {
                    continue;
                }
                $temp = [];
                $temp['id'] = $discount_code->id;
                $temp['code'] = $discount_code->code;
                $temp['type'] = $discount_code->type;
                $temp['amount'] = $discount_code->amount;
                array_push($result, $temp);
            }
        }
        return $result;
    }
    public function get_membershipcards($user_id)
    {
        $result = [];
        $membershipcards = MemberShip::where('status', 'Active')
            ->whereRaw("'" . date('Y-m-d') . "' >=  STR_TO_DATE( start_at , '%d/%m/%Y' )  and '" . date('Y-m-d') . "' <=  STR_TO_DATE( end_at , '%d/%m/%Y' ) ")
            ->where('user_id', $user_id)
            ->get();
        if (!empty($membershipcards)) {
            foreach ($membershipcards as $membershipcard) {
                $temp = [];
                $temp['id'] = $membershipcard->id;
                $temp['code'] = $membershipcard->membership_no;
                $temp['amount'] = $membershipcard->percent;
                array_push($result, $temp);
            }
        }
        return $result;
    }
    public function check_time(Request $request)
    {
        $is_valid = true;
        return response()->json(['success' => $success, 'is_valid' => $is_valid, 'message' => ""]);
        $date = $this->convert_date($request->get('date'), "d-m-Y");
        $from = $request->get('from');
        $to = $request->get('to');
        $worker_id = $request->get('worker_id');
        $service_id = $request->get('service_id');
        //check if shop was closed
        $day_name = strtolower(date('l', strtotime($date)));
        $weekDay = WeekDay::where('name', $day_name)->first();
        $success = true;
        $message = "";
        //check if from bigger than to
        if (strtotime($from) >= strtotime($to)) {
            $success = false;
            $is_valid = false;
            $message = __('s.to_bigger_than_from');
        }
        //check if center is open or closed
        if (!empty($weekDay) && $weekDay->opening_status == "closed") {
            $success = false;
            $is_valid = false;
            $message = __('s.center_is_closes');
        }
        //check if worker has vacation
        $getWorkerVacation = Vacation::where('worker_id', $worker_id)->where('day', $date)->first();
        if (!empty($getWorkerVacation)) {
            $success = false;
            $is_valid = false;
            $message = __('s.worker_has_vacation');
        }
        //check if worker has service before
        $booking_details = BookingDetails::where('worker_id', $worker_id)
            ->where('_date', $request->get('date'))
            ->whereRaw('( (from_time BETWEEN "' . $from . '" and "' . $to . '") or (to_time BETWEEN "' . $from . '" and "' . $to . '") ) ')
            ->first();
        if (!empty($booking_details)) {
            $success = false;
            $is_valid = false;
            $message = __('s.time_not_valid');
        }
        //check worker shift
        $worker = Worker::find($worker_id);
        if (empty($worker)) {
            $success = false;
            $is_valid = false;
            $message = __('s.worker_not_found');
        }
        if (empty($worker->shift)) {
            $success = false;
            $is_valid = false;
            $message = __('s.sift_not_found');
        }
        if (!empty($worker->shift)) {
            if ($from < $worker->shift->start_time) {
                $success = false;
                $is_valid = false;
                $message = __('s.shift_start_time_is') . ": " . $worker->shift->start_time;
            }
            if ($to > $worker->shift->end_time) {
                $success = false;
                $is_valid = false;
                $message = __('s.shift_end_time_is') . ": " . $worker->shift->end_time;
            }
        }
        //check break start
        if (!empty($worker->shift)) {
            if (
                ($to > $worker->shift->start_time && $to < $worker->shift->start_time) ||
                ($from > $worker->shift->start_time && $from < $worker->shift->start_time)
            ) {
                $success = false;
                $is_valid = false;
                $message = __('s.time_not_valid');
            }
        }

        return response()->json(['success' => $success, 'is_valid' => $is_valid, 'message' => $message]);
    }
    public function destroy(Request $request)
    {
        if (get_user_role() != 1 || get_user_role()==4) {
            dd('no');
        }
        $booking = Booking::findOrFail($request->route('id'));
        if (
            (get_user_role() == 2 && $booking->branch_id != Auth::user()->branch_id) ||
            (get_user_role() == 2 && empty(Auth::user()->branch_id))
        ) {
            set_message('No booking found', 'error');
            return redirect()->back();
        }
        BookingDetails::where('booking_id', $request->route('id'))->delete('');
        UserUsedCard::where('booking_id', $request->route('id'))->delete();
        UserUsedDiscountCode::where('booking_id', $request->route('id'))->delete();
        UserUsedWallet::where('booking_id', $request->route('id'))->delete();
        Booking::where('id', $request->route('id'))->delete('');
        set_message('Booking was delete successfully.');
        return redirect()->back();
    }

    public function get_free_service(Request $request)
    {
        $result = 0;
        $free_packages_ids = [];
        //check if some service has free
        if (isset($request->service_id) && !empty($request->service_id)) {
            foreach ($request->service_id as $service_id) {
                //get free service from package
                $get_package_service = PackageService::where('service_id', $service_id)
                    ->where('is_free', 1)
                    ->get();
                if (!$get_package_service->isEmpty()) {
                    foreach ($get_package_service as $package_service) {
                        array_push($free_packages_ids, $package_service->package_id);
                    }
                }
            }
        }
        //get services
        $packages_with_services = [];
        if (!empty($free_packages_ids)) {
            foreach ($free_packages_ids as $package_id) {
                $package = Package::find($package_id);
                if (!empty($package) && !$package->services->isEmpty()) {
                    $temp = [];
                    foreach ($package->services as $service) {
                        array_push($temp, $service->service_id);
                    }
                    $packages_with_services[$package_id] = $temp;
                }
            }
        }
        if (!empty($packages_with_services)) {
            foreach ($packages_with_services as $package_id => $services) {
                $containsAllNeeded = 0 == count(array_diff($services, $request->service_id));
                if ($containsAllNeeded) {
                    $package = Package::find($package_id);
                    if (!empty($package) && !$package->services->isEmpty()) {
                        foreach ($package->services as $free_service) {
                            if ($free_service->is_free == 1) {
                                $result = $free_service->service_id;
                                break;
                            }
                        }
                    }
                    break;
                }
            }
        }
        return $result;
    }
	
public function get_free_services2(Request $request)
{
    $free_services = [];
    $selected_packages = [];
	$selected_packages2 = [];

    // استخراج الباقات بناءً على الخدمات التي اختارها الزبون
    if (isset($request->service_id) && !empty($request->service_id)) {
        foreach ($request->service_id as $service_id) {
            $package_services = PackageService::where('service_id', $service_id)->pluck('package_id')->toArray();
            $selected_packages = array_merge($selected_packages, $package_services);
        }
    }

    // التحقق من شراء الخدمات المدفوعة في الباقة
    if (!empty($selected_packages)) {
        foreach ($selected_packages as $package_id) {
           
		   // حساب عدد الخدمات المدفوعة في الباقة
            $total_paid_services_in_package = PackageService::where('package_id', $package_id)
                ->where('is_free', 0)
                ->count();

            // حساب عدد الخدمات المدفوعة التي قام الزبون بشرائها من الباقة
            $selected_paid_services_count = PackageService::where('package_id', $package_id)
                ->where('is_free', 0)
                ->whereIn('service_id', $request->service_id)
                ->count();

            // التحقق مما إذا كان الزبون قد قام بشراء جميع الخدمات المدفوعة في الباقة
            if ($total_paid_services_in_package === $selected_paid_services_count) {
                // الفرق يساوي الصفر، نضيف معرّف الباقة إلى المصفوفة
                $selected_packages2 = array_merge($selected_packages2, [$package_id]);
            }
        }
    }

    // الحصول على جميع الخدمات المجانية في الباقات
    if (!empty($selected_packages2)) {
        foreach ($selected_packages2 as $package_id) {
            $package_free_services = PackageService::where('package_id', $package_id)
                ->where('is_free', 1)
                ->pluck('service_id')
                ->toArray();

            $free_services = array_merge($free_services, $package_free_services);
        }
    }

    // إزالة الخدمات المكررة
    $free_services = array_unique($free_services);

    return $free_services;
}


	  
    public function get_booked_free_service(Request $request, $service_id)
    {
        $is_free = 0;
        $get_user = User::where('phone', $request->mobile)->first();
        if (!empty($get_user)) {
            //get service details
            $service_details = Service::find($service_id);
            if (!empty($service_details) && !empty($service_details->free_book)) {
                $free_book = $service_details->free_book;
                $BookingUserService = BookingUserService::where('user_id', $get_user->id)
                    ->where('service_id', $service_id)
                    ->first();
                if (!empty($BookingUserService) && $free_book == $BookingUserService->service_count) {
                    $is_free = 1;
                    //update to zero
                    BookingUserService::where('id', $BookingUserService->id)
                        ->update(['service_count' => 0]);
                } else {
                    //insert
                    if (!empty($BookingUserService)) {
                        BookingUserService::where('id', $BookingUserService->id)
                            ->update(['service_count' => $BookingUserService->service_count + 1]);
                    } else {
                        BookingUserService::create([
                            'user_id' => $get_user->id,
                            'service_id' => $service_id,
                            'service_count' => 1
                        ]);
                    }
                }
            }
        }
        return $is_free;
    }



    /*public function get_discount_codes($user_id){
        $result = [];
        $discount_codes = Discountcode::where('status',1)
            ->whereRaw("'".date('Y-m-d')."' >= start_at and '".date('Y-m-d')."' <=expire_at")
            ->get();
        if(!empty($discount_codes)){
            foreach ($discount_codes as $discount_code){
                $users = [];
                if(!$discount_code->users->isEmpty()){
                    foreach ($discount_code->users as $user){
                        array_push($users,$user->user_id);
                    }
                }
                if(!empty($users) && in_array($user_id,$users)){
                    //check if user used this coupon before
                    $check = UserUsedDiscountCode::where('discountcode_id',$discount_code->id)
                        ->where('user_id',$user_id)->first();
                    if(!empty($check)){
                        foreach ($users as $index=>$ss){
                            if($ss==$user_id){
                                unset($users[$index]);
                            }
                        }
                    }
                    if(in_array($user_id,$users)){
                        $temp = [];
                        $temp['id'] = $discount_code->id;
                        $temp['code'] = $discount_code->code;
                        $temp['type'] = ($discount_code->kind==1) ? 'percent':'fixed';
                        $temp['amount'] = $discount_code->percent;
                        array_push($result,$temp);
                    }
                }

            }
        }
        return $result;
    }*/
}
