<?php

namespace App\Http\Controllers\Branch;

use App\Models\Branch;
use App\Models\Role;
use App\User;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use DataTables;

class BranchController extends Controller
{
    /**
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(Request $request)
    {

        can('branch.view',true);
        if ($request->ajax()) {
            $data = Branch::select('*')->where('status','Active');
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function($row){
                    $btn = "";
                    if(can('branch.edit')){
                        $btn.='<a href="" class="btn btn-primary btn-xs edit-branch" data-id="'.$row->id.'" data-target="#editModal" data-toggle="modal">
                                    <i class="fa fa-edit"></i>
                                </a>';
                    }
                    if(can('branch.delete')){
                        $btn.='<a href="'.set_route('branch.delete',['id'=>$row->id]).'" class="btn btn-danger btn-xs delete-row">
                                    <i class="fa fa-close"></i>
                                </a>';
                    }
                    return $btn;
                })
                ->rawColumns(['action'])
                ->make(true);
        }
        $roles = Role::all();
        return view('branch.index',compact('roles'));
    }
    //create
    public function create(Request $request)
    {
        can('branch.create',true);
        $roles = Role::all();
        return view('branch.create',compact('roles'));
    }
    public function store(Request $request){
        can('branch.create',true);
        $message_result = [];
        $validator = Validator::make($request->all(), [
            'name_en' => 'required',
        ]);
        if ($validator->fails()) {
            $messages = $validator->messages();
            foreach ($messages->all('<p>:message</p>') as $index => $message) {
                array_push($message_result, $message);
            }
            return response()->json(['success' => false, 'message' => $message_result]);
        }else{
            $data = $request->all();
            Branch::create($data);
            set_message('Branch was saved successfully.');
        }
        return response()->json(['success'=>true,'message'=>'Branch was saved successfully.']);
    }
    //update
    public function edit(Request $request){
        $row = Branch::find($request->get('id'));
        return response()->json(['success'=>true,'row'=>$row]);
    }
    public function update(Request $request){
        can('branch.edit',true);
        $data = $request->all();
        if(isset($data['_token'])){
            unset($data['_token']);
        }
        Branch::where('id',$request->get('id'))->update($data);
        return response()->json(['success'=>true,'message'=>'Branch was saved successfully.']);
    }
    //delete
    public function destroy(Request $request){
        can('branch.delete',true);
        $row = Branch::findOrFail($request->route('id'));
        $row->delete();
        set_message('Branch was delete successfully.');
        return redirect()->back();
    }
}
