<?php

namespace App\Http\Controllers\Customer;

use App\Models\UserWallet;
use App\Models\Wallet;
use App\Models\Role;
use App\Http\Controllers\Controller;
use App\Models\Worker;
use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use DataTables;
use Dompdf\Dompdf;
use Illuminate\Support\Str;
use PDF;

class WalletController extends Controller
{
    /**
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(Request $request)
    {

        can('wallet.view', true);
        if ($request->ajax()) {
            $data = Wallet::select('*')->with('users');
            if (get_user_role() == 2) {
                $data->whereHas('created_by_user', function ($query) {
                    return $query->where('branch_id', Auth::user()->branch_id);
                });
            }
            return Datatables::of($data)
                ->addIndexColumn()
                ->editColumn('amount', function ($row) {
                    return get_currency() . $row->amount;
                })
                ->editColumn('invoiced_amount', function ($row) {
                    return get_currency() . $row->invoiced_amount;
                })
                ->editColumn('created_by', function ($row) {
                    return (!empty($row->created_by_user)) ? $row->created_by_user->first_name . ' ' . $row->created_by_user->last_name : '';
                })
                ->editColumn('used', function ($row) {
                    return (empty($row->used)) ? 'No' : 'Yes';
                })
                ->addColumn('users', function ($row) {
                    $template = "";
                    if (!$row->users->isEmpty()) {
                        foreach ($row->users as $user) {
                            if (!empty($user->user)) {
                                $template .= $user->user->first_name . ' ' . $user->user->last_name . "<br>";
                            }
                        }
                    }
                    return $template;
                })
                ->addColumn('action', function ($row) {
                    $btn = "";
                    $btn .= '<a href="" class="btn btn-warning btn-xs show-wallet-users" data-code="' . $row->code . '" data-id="' . $row->id . '" data-target="#showWalletUserModal" data-toggle="modal">
                                    <i class="fa fa-print"></i>
                                </a>';
                    $btn .= '<a data-toggle="modal" data-wallet-name="' . $row->code . '" data-target="#userModal" href="" class="btn btn-success btn-xs show-users" data-wallet-value="'.$row->invoiced_amount.'" data-id="' . $row->id . '">
                                    <i class="fa fa-user-plus"></i>
                                </a>';
                    if (can('wallet.edit')) {
                        $btn .= '<a href="" class="btn btn-primary btn-xs edit-wallet" data-id="' . $row->id . '" data-target="#editModal" data-toggle="modal">
                                    <i class="fa fa-edit"></i>
                                </a>';
                    }
                    if (can('wallet.delete')) {
                        $btn .= '<a href="' . set_route('wallet.delete', ['id' => $row->id]) . '" class="btn btn-danger btn-xs delete-row">
                                    <i class="fa fa-close"></i>
                                </a>';
                    }

                    return $btn;
                })
                ->rawColumns(['action', 'users'])
                ->make(true);
        }
        $users = User::where('role_id', 3)->get();
        $workers = Worker::all();
        return view('wallet.index', compact('users', 'workers'));
    }
    //create
    public function create(Request $request)
    {
        can('wallet.create', true);
        $roles = Role::all();
        return view('wallet.create', compact('roles'));
    }
    public function store(Request $request)
    {
        can('wallet.create', true);
        $message_result = [];
        //$request->start_at =now()->format('d/m/Y');
        //$new_format = ($request->end_at)->format('Y-m-d');
        //return date('d/m/Y', strtotime($request->end_at));
        //return date('d/m/Y', strtotime($request->end_at));
        //return \Carbon\Carbon::parse($request->end_at)->format('d/m/Y');
        $validator = Validator::make($request->all(), [
            'amount' => 'required',
            'end_at' => 'required'
        ]);
        if ($validator->fails()) {
            $messages = $validator->messages();
            foreach ($messages->all('<p>:message</p>') as $index => $message) {
                array_push($message_result, $message);
            }
            return response()->json(['success' => false, 'message' => $message_result]);
        } else {
            $data = $request->all();
            $data['code'] =  $code = Str::random(10);
            $data['start_at'] = now()->format('d/m/Y');            
            Wallet::create($data);
            set_message('Wallet was saved successfully.');
        }
        return response()->json(['success' => true, 'message' => 'Wallet was saved successfully.']);
    }
    //update
    public function edit(Request $request)
    {
        $row = Wallet::find($request->get('id'));
        return response()->json(['success' => true, 'row' => $row]);
    }
    public function update(Request $request)
    {
        can('wallet.edit', true);
        $data = $request->all();
        if (isset($data['_token'])) {
            unset($data['_token']);
        }
        Wallet::where('id', $request->get('id'))->update($data);
        return response()->json(['success' => true, 'message' => 'Wallet was saved successfully.']);
    }
    //delete
    public function destroy(Request $request)
    {
        can('wallet.delete', true);
        UserWallet::where('wallet_id', $request->route('id'))->delete();
        $row = Wallet::findOrFail($request->route('id'));
        $row->delete();
        set_message('Wallet was delete successfully.');
        return redirect()->back();
    }
    public function save_users(Request $request)
    {
        //check if user has wallet
        $check = UserWallet::where('user_id', $request->get('user_id'))
            ->where('wallet_id', $request->get('wallet_id'))
            ->where('branch_id', Auth::user()->branch_id)
            ->first();
        if (!empty($check)) {
            return response()->json(['success' => false, 'message' => 'User already has wallet']);
        }
        $wallet = Wallet::find($request->get('wallet_id'));
        if (empty($wallet)) {
            return response()->json(['success' => false, 'message' => 'Wallet not found']);
        }
        $commission = $request->get('commission');
        if (empty($request->worker_id)) {
            $commission = 0;
        }

        UserWallet::create([
            'user_id' => $request->get('user_id'),
            'wallet_id' => $request->get('wallet_id'),
            'amount' => $wallet->amount,
            'invoiced_amount' => $wallet->invoiced_amount,
            'wallet_type' => $request->get('wallet_type'),
            'worker_id' => $request->get('worker_id'),
            'commission' => $commission,
            'branch_id' => Auth::user()->branch_id
        ]);

        $wallet->used = 1;
        $wallet->save();
        
        //update main user wallet
        $user = User::find($request->get('user_id'));
        $user->wallet += $wallet->amount;
        $user->save();

        $this->send_coupon_amount($user->country_code . $user->phone, $wallet->amount, $user->wallet);
        return response()->json(['success' => true, 'message' => 'Wallet was saved successfully.']);
    }

    public function send_coupon_amount($phone_number, $coupon_amount, $new_balance)
    {
        $curl = curl_init();

        curl_setopt_array($curl, [
            CURLOPT_URL => "https://api.msg91.com/api/v5/flow/",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => "{\n  \"flow_id\": \"625f384976525314166e13d3\",\n  \"sender\": \"meenscare\",\n  \"mobiles\": \"$phone_number\",\n  \"coupon_amount\": \"$coupon_amount\",\n  \"new_balance\": \"$new_balance\"\n}",
            CURLOPT_HTTPHEADER => [
                "authkey: 375120AZqrW6qQU62443145P1",
                "content-type: application/JSON"
            ],
        ]);

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);
    }
    public function show_users(Request $request)
    {
        $wallet_id = $request->get('wallet_id');
        $wallet = Wallet::find($wallet_id);
        return response()->json([
            'success' => true,
            'view' => (string)view('wallet.show_users', compact('wallet'))
        ]);
    }
    public function print_user_wallet(Request $request)
    {
        $wallet = Wallet::find($request->get('wallet_id'));
        $user_wallet = UserWallet::where('user_id', $request->user_id)
            ->where('wallet_id', $request->wallet_id)
            ->where('branch_id', Auth::user()->branch_id)
            ->first();
        $user = (object)[];
        if (!empty($user_wallet)) {
            $user = User::find($user_wallet->user_id);
            // return view('wallet.invoice', compact('user','wallet','user_wallet'));
            // $pdf = PDF::loadView('wallet.invoice', compact('user','wallet','user_wallet'));
            // return $pdf->stream('pdfview.pdf');

            $pdf = new Dompdf();
            // $pdf->set_option( 'dpi' , '512' );
            $pdf->setPaper(array(0, 0, 226, 800));
            $GLOBALS['bodyHeight'] = 0;
            $pdf->setCallbacks(
                array(
                    'myCallbacks' => array(
                        'event' => 'end_frame', 'f' => function ($infos) {
                            $frame = $infos["frame"];
                            if (strtolower($frame->get_node()->nodeName) === "body") {
                                $padding_box = $frame->get_padding_box();
                                $GLOBALS['bodyHeight'] += $padding_box['h'];
                            }
                        }
                    )
                )
            );
            $pdf->loadHtml(view('wallet.invoice', compact('user','wallet','user_wallet'))->render());
            $pdf->render();
            unset($pdf);
            $pdf = PDF::loadView('wallet.invoice', compact('user','wallet','user_wallet'));
            // $pdf->dompdf->set_option('dpi' , '512');
            $pdf->setPaper(array(0, 0, 226, $GLOBALS['bodyHeight'] + 50));
            return $pdf->stream('pdfview.pdf');
        }
        dd('No');
    }
}
