<?php

namespace App\Http\Controllers\Product;

use App\Models\Product;
use App\Models\Role;
use App\User;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use DataTables;

class ProductController extends Controller
{
    /**
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(Request $request)
    {

        can('product.view',true);
        if ($request->ajax()) {
            $data = Product::select('*');
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('price',function ($row){
                    return get_currency().get_num_format($row->price);
                })
                ->addColumn('image',function ($row){
                    $btn = "<img width='50' src='assets/img/avatar3_small.jpg'>";
                    if(!empty($row->image)){
                        $btn = '<img width="50" src="'.url(\Storage::url($row->image)).'" />';
                    }
                    return $btn;
                })
                ->addColumn('action', function($row){
                    $btn = "";
                    if(can('product.edit')){
                        $btn.='<a href="" class="btn btn-primary btn-xs edit-product" data-id="'.$row->id.'" data-target="#editModal" data-toggle="modal">
                                    <i class="fa fa-edit"></i>
                                </a>';
                    }
                    if(can('product.delete')){
                        $btn.='<a href="'.set_route('product.delete',['id'=>$row->id]).'" class="btn btn-danger btn-xs delete-row">
                                    <i class="fa fa-close"></i>
                                </a>';
                    }
                    return $btn;
                })
                ->rawColumns(['action','image'])
                ->make(true);
        }
        $roles = Role::all();
        return view('product.index',compact('roles'));
    }
    //create
    public function create(Request $request)
    {
        can('product.create',true);
        $roles = Role::all();
        return view('product.create',compact('roles'));
    }
    public function store(Request $request){
        can('product.create',true);
        $message_result = [];
        $validator = Validator::make($request->all(), [
            'name_en' => 'required',
            'name_ar' => 'required',
        ]);
        if ($validator->fails()) {
            $messages = $validator->messages();
            foreach ($messages->all('<p>:message</p>') as $index => $message) {
                array_push($message_result, $message);
            }
            return response()->json(['success' => false, 'message' => $message_result]);
        }else{
            $data = $request->all();
            $image = "";
            //upload image
            if($request->file('image')){
                $imagePath = $request->file('image');
                $imageName = time().str_replace(' ', '', $imagePath->getClientOriginalName());
                $image = $request->file('image')->storeAs('products/uploads', $imageName,'public');
            }
            $data['image'] = $image;
            Product::create($data);
            set_message('Product was saved successfully.');
        }
        return response()->json(['success'=>true,'message'=>'Product was saved successfully.']);
    }
    //update
    public function edit(Request $request){
        $row = Product::find($request->get('id'));
        return response()->json(['success'=>true,'row'=>$row]);
    }
    public function update(Request $request){
        can('product.edit',true);
        $data = $request->all();
        if(isset($data['_token'])){
            unset($data['_token']);
        }
        $product = Product::find($request->get('id'));
        $image = "";
        //upload image
        if($request->file('image')){
            $imagePath = $request->file('image');
            $imageName = time().str_replace(' ', '', $imagePath->getClientOriginalName());
            $image = $request->file('image')->storeAs('products/uploads', $imageName,'public');
            //delete old file
            Storage::disk('public')->delete($product->image);
        }else{
            $image = $product->image;
        }
        $data['image'] = $image;
        Product::where('id',$request->get('id'))->update($data);
        return response()->json(['success'=>true,'message'=>'Product was saved successfully.']);
    }
    //delete
    public function destroy(Request $request){
        can('product.delete',true);
        $row = Product::findOrFail($request->route('id'));
        $row->delete();
        set_message('Product was delete successfully.');
        return redirect()->back();
    }
}
