<?php

namespace App\Http\Controllers\Report;

use App\Http\Controllers\Booking\BookingController;
use App\Models\Booking;
use App\Models\Branch;
use App\Models\BuyProduct;
use App\Models\Shift;
use App\Models\Role;
use App\Models\UserUsedCard;
use App\Models\UserUsedDiscountCode;
use App\Models\UserWallet;
use App\Models\Worker;
use App\User;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use DataTables;
use DB;
use PDF;

class ReportController extends Controller
{
    public function daily_report(Request $request)
    {
        $date = $request->get('date');
        $branch_id = $request->get('branch_id');
        $var = $date;
        if (empty($var)) {
            $var = date('d/m/Y');
        }
        $result = [];
        $users = [];
        $report = "";
        $users_with_prices = [];
        $users_with_commission = [];
        $payments_with_prices = [];
        $payments_type = [];
        $temp_branches = Branch::where('id', '>', 0);
        if (get_user_role() != 1) {
            $temp_branches->where('id', Auth::user()->branch_id);
        }
        $branches = $temp_branches->get();
        $selected_branch = $request->get('branch_id');
        $product_details_prices = [
            'sales_cash' => 0,
            'sales_visa' => 0
        ];

        $wallet_details_prices = [
            'sales_cash' => 0,
            'sales_visa' => 0
        ];


        if (!empty($date)) {
            $date = convert_date($date);
            $date = date('Y-m-d', strtotime($date));

            $temp_report = Booking::whereRaw('booking_date="' . $date . '"')
                ->with('details');
            if (!empty($request->get('branch_id'))) {
                $temp_report->where('branch_id', $request->get('branch_id'));
            }
            $report = $temp_report->get();
            $payments_type = BookingController::get_payment_types();
            $payments_type_list = [];
            $payments_with_prices = [];
            foreach ($payments_type as $index => $item) {
                $payments_type_list[$index] = 0;
                $payments_with_prices[$index] = [];
            }

            $result = [];
            $users_with_prices = [];
            $users_with_commission = [];
            $temp_users = Worker::where('id', '>', 0);
            if (get_user_role() != 1) {
                $temp_users->where('branch_id', Auth::user()->branch_id);
            }
            if (!empty($branch_id)) {
                $temp_users->where('branch_id', $branch_id);
            }
            $users = $temp_users->get();
            foreach ($users as $user) {
                $result[$user->id] = $payments_type_list;
                $users_with_prices[$user->id] = [];
                $users_with_commission[$user->id] = [];
            }
            $booking_with_discount = [];
            //check member ship cards
            $memberShipCardsUsers = [];
            $selected_memberShipCardsUsers = [];
            $temp_memberShipCards = UserUsedCard::with('booking', 'booking.details')
                ->whereRaw('DATE(created_at)="' . $date . '"');
            if (get_user_role() == 2) {
                $temp_memberShipCards->whereHas('booking', function ($query) {
                    return $query->where('branch_id', Auth::user()->branch_id);
                });
            }
            $memberShipCards = $temp_memberShipCards->get();
            if (!$memberShipCards->isEmpty()) {
                foreach ($memberShipCards as $memberShipCard) {
                    $amount = $memberShipCard->amount;
                    if (!empty($memberShipCard->booking) && !empty($memberShipCard->booking->details)) {
                        foreach ($memberShipCard->booking->details as $detail) {
                            $user_amount = ($detail->price * $amount) / 100;
                            if (isset($memberShipCardsUsers[$detail->worker_id])) {
                                $memberShipCardsUsers[$detail->worker_id]['amount'] += $user_amount;
                            } else {
                                $memberShipCardsUsers[$detail->worker_id]['amount'] = $user_amount;
                                $memberShipCardsUsers[$detail->worker_id]['code'] = $memberShipCard->code;
                                $memberShipCardsUsers[$detail->worker_id]['booking_id'] = $memberShipCard->booking->id;
                            }
                            //push to booking
                            if (isset($booking_with_discount[$memberShipCard->booking->id])) {
                                if (isset($booking_with_discount[$memberShipCard->booking->id][$detail->worker_id][$detail->service_id])) {
                                    $booking_with_discount[$memberShipCard->booking->id][$detail->worker_id][$detail->service_id] += $user_amount;
                                } else {
                                    $booking_with_discount[$memberShipCard->booking->id][$detail->worker_id][$detail->service_id] = $user_amount;
                                }
                            } else {
                                $booking_with_discount[$memberShipCard->booking->id][$detail->worker_id][$detail->service_id] = $user_amount;
                            }
                        }
                    }
                }
            }

            //check coupon
            $discountUsers = [];
            $selected_discountUsers = [];
            $temp_discount = UserUsedDiscountCode::with('booking', 'booking.details')->whereRaw('DATE(created_at)="' . $date . '"');
            if (get_user_role() == 2) {
                $temp_discount->whereHas('booking', function ($query) {
                    return $query->where('branch_id', Auth::user()->branch_id);
                });
            }
            $discount = $temp_discount->get();
            if (!$discount->isEmpty()) {
                foreach ($discount as $static) {
                    $amount = $static->amount;
                    if (!empty($static->booking) && !empty($static->booking->details)) {
                        foreach ($static->booking->details as $detail) {
                            if ($static->type == "fixed") {
                                $user_amount = $amount;
                            } else {
                                $user_amount = ($detail->price * $amount) / 100;
                            }
                            if (isset($discountUsers[$detail->worker_id])) {
                                $discountUsers[$detail->worker_id]['amount'] += $user_amount;
                            } else {
                                $discountUsers[$detail->worker_id]['amount'] = $user_amount;
                                $discountUsers[$detail->worker_id]['booking_id'] = $static->booking->id;
                            }

                            //push to booking
                            if (isset($booking_with_discount[$static->booking->id])) {
                                if (isset($booking_with_discount[$static->booking->id][$detail->worker_id][$detail->service_id])) {
                                    $booking_with_discount[$static->booking->id][$detail->worker_id][$detail->service_id] += $user_amount;
                                } else {
                                    $booking_with_discount[$static->booking->id][$detail->worker_id][$detail->service_id] = $user_amount;
                                }
                            } else {
                                $booking_with_discount[$static->booking->id][$detail->worker_id][$detail->service_id] = $user_amount;
                            }
                        }
                    }
                }
            }

            //for report
            if (!$report->isEmpty()) {
                foreach ($report as $value) {
                    $full_name = $value->full_name;
                    $mobile = $value->mobile;
                    $price = 0;
                    if (!empty($value->details)) {
                        foreach ($value->details as $detail) {
                            if (isset($result[$detail->worker_id])) {
                                $price = $detail->price;
                                $payment_type_select = $value->payment_type;
                                if (empty($value->payment_type)) {
                                    $payment_type_select = 'wallet';
                                }
                                $result[$detail->worker_id][$payment_type_select] += $price;
                                array_push($users_with_prices[$detail->worker_id], $price);
                                if (!empty($detail->commission) && $detail->commission != 0) {
                                    array_push($users_with_commission[$detail->worker_id], $detail->commission);
                                }
                                //check if user has free
                                $free_price = 0;
                                if (isset($booking_with_discount[$value->id][$detail->worker_id][$detail->service_id])) {
                                    $free_price = $booking_with_discount[$value->id][$detail->worker_id][$detail->service_id];
                                }
                                //check for free service
                                if ($detail->is_free == 1) {
                                    $free_price += $detail->price;
                                }
                                $payments_with_prices[$payment_type_select][$detail->worker_id][] = $price - $free_price;
                                //for member ship free
                                if (isset($memberShipCardsUsers[$detail->worker_id]) && $value->id == $memberShipCardsUsers[$detail->worker_id]['booking_id'] && !in_array($detail->worker_id, $selected_memberShipCardsUsers)) {
                                    $temp = [];
                                    $temp['amount'] = $memberShipCardsUsers[$detail->worker_id]['amount'];
                                    $temp['type'] = "member_ship";
                                    $temp['code'] = $memberShipCardsUsers[$detail->worker_id]['code'];
                                    $temp['client_name'] = $full_name;
                                    $payments_with_prices["free"][$detail->worker_id][] = $temp;
                                    array_push($selected_memberShipCardsUsers, $detail->worker_id);
                                }
                                //for discount free
                                if (isset($discountUsers[$detail->worker_id]) && $value->id == $discountUsers[$detail->worker_id]['booking_id'] && !in_array($detail->worker_id, $selected_discountUsers)) {

                                    $temp = [];
                                    $temp['amount'] = $discountUsers[$detail->worker_id]['amount'];
                                    $temp['type'] = "discount_code";
                                    $temp['code'] = "";
                                    $temp['client_name'] = $mobile;
                                    $payments_with_prices["free"][$detail->worker_id][] = $temp;
                                    //$payments_with_prices["free"][$detail->worker_id][] = $discountUsers[$detail->worker_id];
                                    array_push($selected_discountUsers, $detail->worker_id);
                                }
                                //for free services
                                if ($detail->is_free == 1) {
                                    $temp = [];
                                    $temp['amount'] = $detail->price;
                                    $temp['type'] = "free_service";
                                    $temp['code'] = "";
                                    $temp['client_name'] = $mobile;
                                    $payments_with_prices["free"][$detail->worker_id][] = $temp;
                                }
                            }
                        }
                    }
                }
            }
            //get for products
            $temp_BuyProduct = BuyProduct::with('details')->whereRaw('DATE(created_at)="' . $date . '"');
            if (get_user_role() == 2) {
                $temp_BuyProduct->whereHas('created_by_user', function ($query) {
                    return $query->where('branch_id', Auth::user()->branch_id);
                });
            }
            $BuyProduct = $temp_BuyProduct->get();
            if (!empty($BuyProduct)) {
                foreach ($BuyProduct as $BuyProduct_item) {
                    $date = date('Y-m-d', strtotime($BuyProduct_item->created_at));
                    if (!$BuyProduct_item->details->isEmpty()) {
                        foreach ($BuyProduct_item->details as $detail) {
                            if (isset($product_details_prices[$BuyProduct_item->payment_type])) {
                                $product_price = $detail->price;
                                if (!empty($BuyProduct_item->discount)) {
                                    $product_price -= ($product_price * $BuyProduct_item->discount) / 100;
                                }
                                $product_details_prices[$BuyProduct_item->payment_type] += $product_price;
                            }
                        }
                    }
                    //worker commission
                    if (isset($users_with_commission[$BuyProduct_item->worker_id])) {
                        array_push($users_with_commission[$BuyProduct_item->worker_id], $BuyProduct_item->commission);
                    }
                }
            }
            //get for wallet
            $temp_get_wallets = UserWallet::whereRaw('DATE(created_at)="' . $date . '"');
            if (get_user_role() == 2) {
                $temp_get_wallets->whereHas('created_by_user', function ($query) {
                    return $query->where('branch_id', Auth::user()->branch_id);
                });
            }
            $get_wallets = $temp_get_wallets->get();
            if (!$get_wallets->isEmpty()) {
                foreach ($get_wallets as $get_wallet) {
                    if (isset($wallet_details_prices[$get_wallet->wallet_type])) {
                        $wallet_details_prices[$get_wallet->wallet_type] += $get_wallet->invoiced_amount;
                        //worker commission
                        if (isset($users_with_commission[$get_wallet->worker_id])) {
                            array_push($users_with_commission[$get_wallet->worker_id], $get_wallet->commission);
                        }
                    }
                }
            }
        }
        $template = (string)view('report.template.daily_report', compact('result', 'users', 'var', 'report', 'users_with_prices', 'payments_with_prices', 'payments_type', 'product_details_prices', 'wallet_details_prices', 'users_with_commission'));
        if (isset($request->is_pdf)) {
            $pdf = PDF::loadView('report.pdf.daily_report', compact('result', 'users', 'var', 'report', 'users_with_prices', 'payments_with_prices', 'payments_type', 'product_details_prices', 'template', 'wallet_details_prices'))->setPaper('a4', 'landscape');
            return $pdf->stream('pdfview.pdf');
        }
        return view('report.daily_report', compact('date', 'var', 'template', 'branches', 'selected_branch', 'product_details_prices', 'request', 'wallet_details_prices', 'users_with_commission'));
    }
    public function sales(Request $request)
    {
        $branch_id = $request->get('branch_id');
        $years = Booking::select(DB::raw('DISTINCT YEAR(booking_date) as year'))
            ->get();
        $selected_year = $request->get('year');
        $selected_month = $request->get('month');
        $temp_branches = Branch::where('id', '>', 0);
        if (get_user_role() != 1) {
            $temp_branches->where('id', Auth::user()->branch_id);
        }
        $branches = $temp_branches->get();
        $selected_branch = $request->get('branch_id');
        $template = "";
        if (!empty($request->year)) {
            $temp_report = Booking::whereRaw('YEAR(booking_date)="' . $request->get('year') . '"')
                ->whereRaw('MONTH(booking_date)="' . $request->get('month') . '"')
                ->with('details');
            if (!empty($request->get('branch_id'))) {
                $temp_report->where('branch_id', $request->get('branch_id'));
            }

            $report = $temp_report->get();
            $payments_type = BookingController::get_payment_types();
            $last_total = [];
            foreach ($payments_type as $index => $value) {
                $last_total[$index] = 0;
            }
            $payments_type['commission'] = __('s.commission');
            $last_total['commission'] = 0;
            $last_total['total_without_free'] = 0;
            $result = [];
            $days = cal_days_in_month(CAL_GREGORIAN, $request->get('month'), $request->get('year'));
            for ($i = 1; $i <= $days; $i++) {
                $month = ($request->get('month') <= 9) ? "0" . $request->get('month') : $request->get('month');
                $day = ($i <= 9) ? "0" . $i : $i;
                $date = $request->get('year') . "-" . $month . "-" . $day;
                $temp = [];
                foreach ($payments_type as $index => $value) {
                    $temp[$index] = 0;
                }
                $temp['commission'] = 0;
                $result[$date] = $temp;
            }
            if (!$report->isEmpty()) {
                foreach ($report as $value) {
                    $price = 0;
                    if (isset($result[$value->booking_date])) {
                        if (!$value->details->isEmpty()) {
                            foreach ($value->details as $detail) {
                                $price += $detail->price;
                                if ($detail->is_free == 1) {
                                    $result[$value->booking_date]['free'] += $detail->price;
                                    //LAMA
                                    //$price -= $detail->price;
                                }
                                //commission
                                $result[$value->booking_date]['commission'] += $detail->commission;
                            }
                        }
                        $selected_payment_type = $value->payment_type;
                        if (empty($value->payment_type)) {
                            $selected_payment_type = "wallet";
                        }
                        $result[$value->booking_date][$selected_payment_type] += $price;
                    }
                }
            }

            //for Free
            $temp_memberShipCards = UserUsedCard::with('booking', 'booking.details')->whereRaw('YEAR(created_at)="' . $request->get('year') . '" and MONTH(created_at)="' . $request->get('month') . '"');
            if (get_user_role() == 2) {
                $temp_memberShipCards->whereHas('booking', function ($query) {
                    return $query->where('branch_id', Auth::user()->branch_id);
                });
            }
            $memberShipCards = $temp_memberShipCards->get();
            if (!$memberShipCards->isEmpty()) {
                foreach ($memberShipCards as $memberShipCard) {
                    $amount = $memberShipCard->amount;
                    if (!empty($memberShipCard->booking) && !empty($memberShipCard->booking->details)) {
                        foreach ($memberShipCard->booking->details as $detail) {
                            $user_amount = ($detail->price * $amount) / 100;
                            $result[$memberShipCard->booking->booking_date]['free'] += $user_amount;
                        }
                    }
                }
            }
            $temp_discount = UserUsedDiscountCode::with('booking', 'booking.details')->whereRaw('YEAR(created_at)="' . $request->get('year') . '" and MONTH(created_at)="' . $request->get('month') . '"');
            if (get_user_role() == 2) {
                $temp_discount->whereHas('booking', function ($query) {
                    return $query->where('branch_id', Auth::user()->branch_id);
                });
            }
            $discount = $temp_discount->get();
            if (!$discount->isEmpty()) {
                foreach ($discount as $static) {
                    $amount = $static->amount;
                    if (!empty($static->booking) && !empty($static->booking->details)) {
                        $selected_payment_type = $static->booking->payment_type;
                        if (empty($static->booking->payment_type)) {
                            $selected_payment_type = "wallet";
                        }
                        foreach ($static->booking->details as $detail) {
                            if ($static->type == "fixed") {
                                $user_amount = $amount;
                            } else {
                                $user_amount = ($detail->price * $amount) / 100;
                            }
                            if (isset($result[$static->booking->booking_date])) {
                                $result[$static->booking->booking_date]['free'] += $user_amount;
                                //LAMA
                                //$result[$static->booking->booking_date][$selected_payment_type] -= $user_amount;
                            }
                        }
                    }
                }
            }

            //get sales cash and sales visa
            $temp_users_wallets = UserWallet::whereRaw('YEAR(created_at)="' . $request->get('year') . '" and MONTH(created_at)="' . $request->get('month') . '"');
            if (get_user_role() == 2) {
                $temp_users_wallets->whereHas('created_by_user', function ($query) {
                    return $query->where('branch_id', Auth::user()->branch_id);
                });
            }
            $users_wallets = $temp_users_wallets->get();
            if (!empty($users_wallets)) {
                foreach ($users_wallets as $users_wallet) {
                    $date = date('Y-m-d', strtotime($users_wallet->created_at));
                    if ($users_wallet->wallet_type == "sales_visa") {
                        $result[$date]['sales_visa_cp'] += $users_wallet->invoiced_amount;
                    } else {
                        $result[$date]['sales_cash_cp'] += $users_wallet->invoiced_amount;
                    }

                    //worker commission
                    if (!empty($users_wallet->commission)) {
                        $result[$date]['commission'] += $users_wallet->commission;
                    }
                }
            }
            //get for products
            $temp_BuyProduct = BuyProduct::whereRaw('YEAR(created_at)="' . $request->get('year') . '" and MONTH(created_at)="' . $request->get('month') . '"')->with('details');
            if (get_user_role() == 2) {
                $temp_BuyProduct->whereHas('created_by_user', function ($query) {
                    return $query->where('branch_id', Auth::user()->branch_id);
                });
            }
            $BuyProduct = $temp_BuyProduct->get();
            if (!empty($BuyProduct)) {
                foreach ($BuyProduct as $BuyProduct_item) {
                    $date = date('Y-m-d', strtotime($BuyProduct_item->created_at));
                    if (!$BuyProduct_item->details->isEmpty()) {
                        foreach ($BuyProduct_item->details as $detail) {
                            if (isset($result[$date][$BuyProduct_item->payment_type])) {
                                $product_price = $detail->price;
                                if (!empty($BuyProduct_item->discount)) {
                                    $product_price -= ($product_price * $BuyProduct_item->discount) / 100;
                                }

                                $result[$date][$BuyProduct_item->payment_type] += $product_price;
                            }
                        }
                    }
                    //worker commission
                    if (!empty($BuyProduct_item->commission)) {
                        $result[$date]['commission'] += $BuyProduct_item->commission;
                    }
                }
            }
            $template = (string)view('report.template.sales_report', compact('result', 'payments_type', 'last_total'));

            if (isset($request->is_pdf)) {
                $pdf = PDF::loadView('report.pdf.sales_report', compact('result', 'payments_type', 'last_total', 'template'))->setPaper('a4', 'landscape');
                return $pdf->stream('pdfview.pdf');
            }
        }
        return view('report.sales_report', compact('years', 'template', 'selected_year', 'selected_month', 'branches', 'selected_branch', 'request'));
    }
    public function staff(Request $request)
    {
        $branch_id = $request->get('branch_id');
        $years = Booking::select(DB::raw('DISTINCT YEAR(booking_date) as year'))
            ->get();
        $selected_year = $request->get('year');
        $selected_month = $request->get('month');
        $template = "";
        $temp_branches = Branch::where('id', '>', 0);
        if (get_user_role() != 1) {
            $temp_branches->where('id', Auth::user()->branch_id);
        }
        $branches = $temp_branches->get();
        $selected_branch = $request->get('branch_id');
        if (!empty($request->year)) {
            $temp_report = Booking::whereRaw('YEAR(booking_date)="' . $request->get('year') . '"')
                ->whereRaw('MONTH(booking_date)="' . $request->get('month') . '"')
                ->with('details');

            if (!empty($request->get('branch_id'))) {
                $temp_report->where('branch_id', $request->get('branch_id'));
            }
            $report = $temp_report->get();
            $temp_users = Worker::where('id', '>', 0);
            if (get_user_role() != 1) {
                $temp_users->where('branch_id', Auth::user()->branch_id);
            }
            if (!empty($branch_id)) {
                $temp_users->where('branch_id', $branch_id);
            }
            $users = $temp_users->get();
            $last_total = [];
            foreach ($users as $index => $value) {
                $last_total[$value->id] = 0;
            }
            $result = [];
            //for free
            $memberShipCardsUsers = [];
            $discountUsers = [];

            $days = cal_days_in_month(CAL_GREGORIAN, $request->get('month'), $request->get('year'));
            for ($i = 1; $i <= $days; $i++) {
                $month = ($request->get('month') <= 9) ? "0" . $request->get('month') : $request->get('month');
                $day = ($i <= 9) ? "0" . $i : $i;
                $date = $request->get('year') . "-" . $month . "-" . $day;
                $temp = [];
                foreach ($users as $index => $value) {
                    $temp[$value->id] = 0;
                }
                $result[$date] = $temp;
                $memberShipCardsUsers[$date] = $temp;
                $discountUsers[$date] = $temp;
            }
            //check member ship cards
            $selected_memberShipCardsUsers = [];
            /*$memberShipCards = UserUsedCard::with('booking','booking.details')->whereRaw('YEAR(created_at)="'.$request->get('year').'"')
                ->whereRaw('MONTH(created_at)="'.$request->get('month').'"')->get();
            if(!$memberShipCards->isEmpty()){
                foreach ($memberShipCards as $memberShipCard){
                    $amount = $memberShipCard->amount;
                    if(!empty($memberShipCard->booking) && !empty($memberShipCard->booking->details))
                    {
                        foreach ($memberShipCard->booking->details as $detail){
                            $user_amount = ($detail->price * $amount) / 100;
                            if(isset($memberShipCardsUsers[date('Y-m-d',strtotime($memberShipCard->created_at))][$detail->worker_id])) {
                                $memberShipCardsUsers[date('Y-m-d', strtotime($memberShipCard->created_at))][$detail->worker_id] += $user_amount;
                            }
                        }
                    }
                }
            }

            //check coupon
            $selected_discountUsers = [];
            $discount = UserUsedDiscountCode::with('booking','booking.details')->whereRaw('YEAR(created_at)="'.$request->get('year').'"')
                ->whereRaw('MONTH(created_at)="'.$request->get('month').'"')->get();
            if(!$discount->isEmpty()){
                foreach ($discount as $static){
                    $amount = $static->amount;
                    if(!empty($static->booking) && !empty($static->booking->details))
                    {
                        foreach ($static->booking->details as $detail){
                            if($static->type=="fixed"){
                                $user_amount = $amount;
                            }else {
                                $user_amount = ($detail->price * $amount) / 100;
                            }
                            if(isset($discountUsers[date('Y-m-d',strtotime($static->created_at))][$detail->worker_id])) {
                                $discountUsers[date('Y-m-d', strtotime($static->created_at))][$detail->worker_id] += $user_amount;
                            }
                        }
                    }
                }
            }*/


            //for report
            if (!$report->isEmpty()) {
                foreach ($report as $value) {
                    $price = 0;
                    if (isset($result[$value->booking_date])) {
                        if (!$value->details->isEmpty()) {
                            foreach ($value->details as $detail) {
                                if (!isset($result[$value->booking_date][$detail->worker_id])) {
                                    continue;
                                }
                                $price = $detail->price;
                                $result[$value->booking_date][$detail->worker_id] += $price;
                            }
                        }
                    }
                }
            }
            //remove for free
            if (!empty($result)) {
                foreach ($result as $date => $workers_list) {
                    foreach ($workers_list as $worker_id => $price) {
                        if (isset($memberShipCardsUsers[$date][$worker_id])) {
                            $result[$date][$worker_id] -= $memberShipCardsUsers[$date][$worker_id];
                        }

                        if (isset($discountUsers[$date][$worker_id])) {
                            $result[$date][$worker_id] -= $discountUsers[$date][$worker_id];
                        }
                    }
                }
            }


            $template = (string)view('report.template.staff_report', compact('result', 'users', 'last_total'));

            if (isset($request->is_pdf)) {
                $pdf = PDF::loadView('report.pdf.staff_report', compact('result', 'users', 'last_total', 'template'))->setPaper('a4', 'landscape');
                return $pdf->stream('pdfview.pdf');
            }
        }


        return view('report.staff_report', compact('years', 'template', 'selected_year', 'selected_month', 'branches', 'selected_branch', 'request'));
    }
}
