<?php

namespace App\Models;

use App\Http\Controllers\Visitor\Error\ErrorController;
use Exception;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\App;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class BookingDetails extends Model
{

    protected $table = "bookings_details";

    protected $fillable = [
        'booking_id',
        'service_id',
        'from_time',
        'to_time',
        '_date',
        'worker_id',
        'price',
        'is_free',
        'user_id',
        'commission',
        'tip',
    ];
    public function booking(){
        return $this->belongsTo(Booking::class,'booking_id');
    }
    public function service(){
        return $this->belongsTo(Service::class,'service_id');
    }
    public function worker(){
        return $this->belongsTo(Worker::class,'worker_id');
    }
    
}
