<?php

namespace App\Models;
use App\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
class Product extends Model
{

    //soft delete
    use SoftDeletes;
    //timestamp
    public $timestamps = true;
    //table
    protected $table = "products";
    protected $fillable = [
        'name_en',
        'name_ar',
        'short_description_ar',
        'short_description_en',
        'price',
        'status',
        'image',
    ];
    public static function boot()
    {
        parent::boot();

        static::created(function(Product $row)
        {
            set_log('Product','insert',$row->id);
        });
        static::updated(function(Product $row)
        {
            set_log('Product','update',$row->id);
        });
        static::deleted(function(Product $row)
        {
            set_log('Product','delete',$row->id);
        });
    }
}
