<?php

namespace App\Models;
use App\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
class Service extends Model
{

    //soft delete
    use SoftDeletes;
    //timestamp
    public $timestamps = true;
    //table
    protected $table = "services";
    protected $fillable = [
        'name_en',
        'name_ar',
        'rooms_no',
        'free_book',
        'max_time',
        'price',
        'sort_order',
        'status',
        'top_service',
        'extra_time',
        'image',
        'has_commission',
    ];
    public static function boot()
    {
        parent::boot();
        static::created(function(Service $row)
        {
            set_log('Service','insert',$row->id);
        });
        static::updated(function(Service $row)
        {
            set_log('Service','update',$row->id);
        });
        static::deleted(function(Service $row)
        {
            set_log('Service','delete',$row->id);
        });

    }
    public function workers(){
        return $this->hasMany(WorkerService::class,'service_id');
    }
}
