<?php

namespace App\Models;
use App\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
class Shift extends Model
{

    //soft delete
    use SoftDeletes;
    //timestamp
    public $timestamps = true;
    //table
    protected $table = "shifts";
    protected $fillable = [
        'name',
        'start_time',
        'end_time',
        'break_start',
        'break_end',
        'status',
    ];
    public static function boot()
    {
        parent::boot();

        static::created(function(Shift $row)
        {
            set_log('Shift','insert',$row->id);
        });
        static::updated(function(Shift $row)
        {
            set_log('Shift','update',$row->id);
        });
        static::deleted(function(Shift $row)
        {
            set_log('Shift','delete',$row->id);
        });
    }
}
