<?php

namespace App\Models;

use App\Http\Controllers\Visitor\Error\ErrorController;
use App\User;
use Exception;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\App;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class UserUsedCard extends Model
{


    protected $table = "users_used_cards";

    protected $fillable = [
        'user_id',
        'membershipcards_id',
        'code',
        'amount',
        'booking_id',
    ];
    public function user(){
        return $this->belongsTo(User::class,'user_id');
    }
    public function card(){
        return $this->belongsTo(MemberShip::class,'membershipcards_id');
    }
    public function booking(){
        return $this->belongsTo(Booking::class,'booking_id');
    }
    
}
