<?php

namespace App\Models;

use App\Http\Controllers\Visitor\Error\ErrorController;
use App\User;
use Exception;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\App;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class UserUsedDiscountCode extends Model
{


    protected $table = "users_used_discount";

    protected $fillable = [
        'user_id',
        'discountcode_id',
        'code',
        'amount',
        'type',
        'booking_id',
    ];
    public function user(){
        return $this->belongsTo(User::class,'user_id');
    }
    public function discount_code(){
        return $this->belongsTo(Discount::class,'discountcode_id');
    }
    public function booking(){
        return $this->belongsTo(Booking::class,'booking_id');
    }
    
}
