<?php

namespace App\Models;

use App\Http\Controllers\Visitor\Error\ErrorController;
use App\User;
use Exception;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\App;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class UserUsedWallet extends Model
{


    protected $table = "users_used_wallet";

    protected $fillable = [
        'user_id',
        'wallet_id',
        'amount',
        'booking_id',
        'branch_id'
    ];
    public function user(){
        return $this->belongsTo(User::class,'user_id');
    }
    public function wallet(){
        return $this->belongsTo(Wallet::class,'wallet_id');
    }
    
    public function branch()
    {
        return $this->belongsTo(Branch::class,'branch_id');
    }
    
}
