<?php

namespace App\Models;
use App\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Auth;
class UserWallet extends Model
{

    //soft delete
    use SoftDeletes;
    //timestamp
    public $timestamps = true;
    //table
    protected $table = "users_wallets";
    protected $fillable = [
        'wallet_id',
        'user_id',
        'wallet_type',
        'amount',
        'invoiced_amount',
        'created_by',
        'worker_id',
        'commission',
        'tip',
        'branch_id'
    ];
    public static function boot()
    {
        parent::boot();

        static::creating(function(UserWallet $row)
        {
            $row->created_by = Auth::id();
            $row->branch_id = Auth::user()->branch_id;
        });


        static::created(function(UserWallet $row)
        {
            set_log('User_wallet','insert',$row->id);
        });
        static::updated(function(UserWallet $row)
        {
            set_log('User_wallet','update',$row->id);
        });
        static::deleted(function(UserWallet $row)
        {
            set_log('User_wallet','delete',$row->id);
        });
    }
    public function wallet(){
        return $this->belongsTo(Wallet::class,'wallet_id');
    }
    public function user(){
        return $this->belongsTo(User::class,'user_id');
    }
    public function created_by_user(){
        return $this->belongsTo(User::class,'created_by');
    }
    public function branch()
    
    {
        return $this->belongsTo(Branch::class,'branch_id');
    }
}
