<?php

namespace App\Models;
use App\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
class Worker extends Model
{

    //soft delete
    use SoftDeletes;
    //timestamp
    public $timestamps = true;
    //table
    protected $table = "workers";
    protected $fillable = [
        'branch_id',
        'shift_id',
        'name',
        'email',
        'phone',
        'image',
        'status',
        'has_commission',
    ];
    public static function boot()
    {
        parent::boot();

        static::created(function(Worker $row)
        {
            set_log('Worker','insert',$row->id);
        });
        static::updated(function(Worker $row)
        {
            set_log('Worker','update',$row->id);
        });
        static::deleted(function(Worker $row)
        {
            set_log('Worker','delete',$row->id);
        });
    }
    public function services(){
        return $this->hasMany(WorkerService::class,'worker_id');
    }
    public function branch(){
        return $this->belongsTo(Branch::class,'branch_id');
    }
    public function vacations(){
        return $this->hasMany(Vacation::class,'worker_id');
    }
    public function shift(){
        return $this->belongsTo(Shift::class,'shift_id');
    }

}
