---
title: API Reference

language_tabs:
- bash
- php

includes:

search: true

toc_footers:
- <a href='http://github.com/mpociot/documentarian'>Documentation Powered by Documentarian</a>
---
<!-- START_INFO -->
# Info

Welcome to the generated API reference.

<!-- END_INFO -->

#Arcadius


<!-- START_f7b7ea397f8939c8bb93e6cab64603ce -->
## Display Swagger API page.

> Example request:

```bash
curl -X GET \
    -G "https://main.allin1uae.com/api/documentation" \
    -H "Content-Type: application/json" \
    -H "Accept: application/json" \
    -H "x-api-key: API_KEY"
```

```php

$client = new \GuzzleHttp\Client();
$response = $client->get(
    'https://main.allin1uae.com/api/documentation',
    [
        'headers' => [
            'Content-Type' => 'application/json',
            'Accept' => 'application/json',
            'x-api-key' => 'API_KEY',
        ],
    ]
);
$body = $response->getBody();
print_r(json_decode((string) $body));
```


> Example response (200):

```json
null
```

### HTTP Request
`GET api/documentation`


<!-- END_f7b7ea397f8939c8bb93e6cab64603ce -->

<!-- START_a2c4ea37605c6d2e3c93b7269030af0a -->
## Display Oauth2 callback pages.

> Example request:

```bash
curl -X GET \
    -G "https://main.allin1uae.com/api/oauth2-callback" \
    -H "Content-Type: application/json" \
    -H "Accept: application/json" \
    -H "x-api-key: API_KEY"
```

```php

$client = new \GuzzleHttp\Client();
$response = $client->get(
    'https://main.allin1uae.com/api/oauth2-callback',
    [
        'headers' => [
            'Content-Type' => 'application/json',
            'Accept' => 'application/json',
            'x-api-key' => 'API_KEY',
        ],
    ]
);
$body = $response->getBody();
print_r(json_decode((string) $body));
```


> Example response (200):

```json
null
```

### HTTP Request
`GET api/oauth2-callback`


<!-- END_a2c4ea37605c6d2e3c93b7269030af0a -->

<!-- START_4cd144993d93b74c6e2ad81b9be3d051 -->
## api/check-email
> Example request:

```bash
curl -X POST \
    "https://main.allin1uae.com/api/check-email" \
    -H "Content-Type: application/json" \
    -H "Accept: application/json" \
    -H "x-api-key: API_KEY" \
    -d '{"email":"vendor@gmail.com"}'

```

```php

$client = new \GuzzleHttp\Client();
$response = $client->post(
    'https://main.allin1uae.com/api/check-email',
    [
        'headers' => [
            'Content-Type' => 'application/json',
            'Accept' => 'application/json',
            'x-api-key' => 'API_KEY',
        ],
        'json' => [
            'email' => 'vendor@gmail.com',
        ],
    ]
);
$body = $response->getBody();
print_r(json_decode((string) $body));
```


> Example response (200):

```json
{
    "success": true,
    "message": []
}
```
> Example response (409):

```json
{
    "success": false,
    "message": [
        "<p>The email already has been token<\/p>"
    ]
}
```

### HTTP Request
`POST api/check-email`

#### Body Parameters
Parameter | Type | Status | Description
--------- | ------- | ------- | ------- | -----------
    `email` | required |  optional  | Email which needs to check
    
<!-- END_4cd144993d93b74c6e2ad81b9be3d051 -->

<!-- START_0d03ea25e43b26c208d187eb624bfec6 -->
## api/create-user
> Example request:

```bash
curl -X POST \
    "https://main.allin1uae.com/api/create-user" \
    -H "Content-Type: application/json" \
    -H "Accept: application/json" \
    -H "x-api-key: API_KEY" \
    -d '{"first_name":"Vendor","last_name":"Vendor","email":"vendor@gmail.com","password":"$2y$12$zqfFAcUk92xc1JYA.Ff.l.M7aQ\/aw9istUlKOm0THfz0rtxrvc\/gK","main_domain":"classification"}'

```

```php

$client = new \GuzzleHttp\Client();
$response = $client->post(
    'https://main.allin1uae.com/api/create-user',
    [
        'headers' => [
            'Content-Type' => 'application/json',
            'Accept' => 'application/json',
            'x-api-key' => 'API_KEY',
        ],
        'json' => [
            'first_name' => 'Vendor',
            'last_name' => 'Vendor',
            'email' => 'vendor@gmail.com',
            'password' => '$2y$12$zqfFAcUk92xc1JYA.Ff.l.M7aQ/aw9istUlKOm0THfz0rtxrvc/gK',
            'main_domain' => 'classification',
        ],
    ]
);
$body = $response->getBody();
print_r(json_decode((string) $body));
```


> Example response (409):

```json
{
    "success": false,
    "message": [
        "<p>First name is required<\/p>",
        "<p>Last name is required<\/p>"
    ]
}
```
> Example response (200):

```json
{
    "success": true,
    "message": [
        "<p>User was created successfully.<\/p>"
    ]
}
```

### HTTP Request
`POST api/create-user`

#### Body Parameters
Parameter | Type | Status | Description
--------- | ------- | ------- | ------- | -----------
    `first_name` | required |  optional  | First name of client
        `last_name` | required |  optional  | Last name of client
        `email` | required |  optional  | Email of client
        `password` | required |  optional  | Password of client (Password must be as hash)
        `main_domain` | required |  optional  | (For classification set [classification] - For E-commerce set [e_commerce])
    
<!-- END_0d03ea25e43b26c208d187eb624bfec6 -->

<!-- START_fd24d109cbd10fe85b8c1a162cab9306 -->
## api/get-systems-list
> Example request:

```bash
curl -X GET \
    -G "https://main.allin1uae.com/api/get-systems-list" \
    -H "Content-Type: application/json" \
    -H "Accept: application/json" \
    -H "x-api-key: API_KEY"
```

```php

$client = new \GuzzleHttp\Client();
$response = $client->get(
    'https://main.allin1uae.com/api/get-systems-list',
    [
        'headers' => [
            'Content-Type' => 'application/json',
            'Accept' => 'application/json',
            'x-api-key' => 'API_KEY',
        ],
    ]
);
$body = $response->getBody();
print_r(json_decode((string) $body));
```


> Example response (200):

```json
{
    "success": true,
    "_list": [
        "e_commerce",
        "classification"
    ]
}
```

### HTTP Request
`GET api/get-systems-list`


<!-- END_fd24d109cbd10fe85b8c1a162cab9306 -->

<!-- START_0ca23f2dc7ca02eaefda57ed2c3264fa -->
## api/p-change-password
> Example request:

```bash
curl -X PUT \
    "https://main.allin1uae.com/api/p-change-password" \
    -H "Content-Type: application/json" \
    -H "Accept: application/json" \
    -H "x-api-key: API_KEY" \
    -d '{"password":"1234","main_id":"2"}'

```

```php

$client = new \GuzzleHttp\Client();
$response = $client->put(
    'https://main.allin1uae.com/api/p-change-password',
    [
        'headers' => [
            'Content-Type' => 'application/json',
            'Accept' => 'application/json',
            'x-api-key' => 'API_KEY',
        ],
        'json' => [
            'password' => '1234',
            'main_id' => '2',
        ],
    ]
);
$body = $response->getBody();
print_r(json_decode((string) $body));
```


> Example response (409):

```json
{
    "success": false,
    "message": [
        "<p>Main id is required<\/p>",
        "<p>Password is required<\/p>"
    ]
}
```
> Example response (200):

```json
{
    "success": true,
    "message": [
        "<p>Password was changed successfully.<\/p>"
    ]
}
```

### HTTP Request
`PUT api/p-change-password`

#### Body Parameters
Parameter | Type | Status | Description
--------- | ------- | ------- | ------- | -----------
    `password` | required |  optional  | Password of user
        `main_id` | required |  optional  | Main id of user
    
<!-- END_0ca23f2dc7ca02eaefda57ed2c3264fa -->

<!-- START_63f5c3dbb22532f7db84528179a77e34 -->
## api/check-phone-status
> Example request:

```bash
curl -X POST \
    "https://main.allin1uae.com/api/check-phone-status" \
    -H "Content-Type: application/json" \
    -H "Accept: application/json" \
    -H "x-api-key: API_KEY" \
    -d '{"phone":"+90545487875"}'

```

```php

$client = new \GuzzleHttp\Client();
$response = $client->post(
    'https://main.allin1uae.com/api/check-phone-status',
    [
        'headers' => [
            'Content-Type' => 'application/json',
            'Accept' => 'application/json',
            'x-api-key' => 'API_KEY',
        ],
        'json' => [
            'phone' => '+90545487875',
        ],
    ]
);
$body = $response->getBody();
print_r(json_decode((string) $body));
```


> Example response (200):

```json
{
    "success": true,
    "message": []
}
```
> Example response (409):

```json
{
    "success": false,
    "message": [
        "<p>The phone already has been token<\/p>"
    ]
}
```

### HTTP Request
`POST api/check-phone-status`

#### Body Parameters
Parameter | Type | Status | Description
--------- | ------- | ------- | ------- | -----------
    `phone` | required |  optional  | Phone which needs to check
    
<!-- END_63f5c3dbb22532f7db84528179a77e34 -->


