@extends('layout')
@section('content')

    <div class="portlet box blue-hoki">
        <div class="portlet-title">
            <div class="caption">
                <i class="fa fa-user"></i>{{ __('s.My Profile') }}
            </div>
        </div>
        <div class="portlet-body">
            <form method="post" id="accountForm" enctype="multipart/form-data">
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label text-black">
                        {{ __('s.first_name') }}
                        <span class="text-danger">*</span></label>
                    <div class="col-sm-9">
                        <input value="{{ \Illuminate\Support\Facades\Auth::user()->first_name }}" name="first_name" type="text" class="form-control" required="">
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label text-black">
                        {{ __('s.last_name') }}
                        <span class="text-danger">*</span></label>
                    <div class="col-sm-9">
                        <input value="{{ \Illuminate\Support\Facades\Auth::user()->last_name }}" name="last_name" type="text" class="form-control" required="">
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label text-black">
                        {{ __('s.email') }}
                        <span class="text-danger">*</span></label>
                    <div class="col-sm-9">
                        <input value="{{ \Illuminate\Support\Facades\Auth::user()->email }}" name="email" type="email" class="form-control" required="">
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-sm-2 col-form-label text-black">{{ __('s.phone') }}
                        <span class="text-danger">*</span></label>
                    <div class="col-sm-9">
                        <div class="input-group">
                            <span class="input-group-addon">+971</span>
                            <input value="{{ \Illuminate\Support\Facades\Auth::user()->phone }}" name="phone" type="text" class="form-control" required>
                        </div>
                    </div>
                </div>



                <div class="form-group row">
                    <label class="col-sm-2 col-form-label text-black">
                        {{ __('s.image') }}
                    </label>
                    <div class="col-sm-9">
                        <input type="file" name="image" accept="image/png, image/jpeg">
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-sm-2 col-form-label text-black"></label>
                    <div class="col-sm-9">
                        <button class="btn btn-success save">{{ __('s.Update') }}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@push('scripts')
<script type="text/javascript">
    $(document).ready(function () {
        $("#accountForm").validate({
            rules: {
                phone: {
                    number: true
                }
            }
        });

        $(document).on("submit","#accountForm",function (e) {
            e.preventDefault();
            var self = $(this);
            // Get form
            var form = self[0];
            // FormData object
            var data = new FormData(form);
            load_btn(self.find('.save'));
            data.append("_token","{{ csrf_token() }}");
            $.ajax({
                type: "POST",
                enctype: 'multipart/form-data',
                url: "{{ set_route('account.profile.update') }}",
                data: data,
                processData: false,
                contentType: false,
                cache: false,
                timeout: 800000,
                success: function (data) {
                    if(data.success){
                        location.reload();
                    }else {
                        toastr.error(data.message,toastar_options);
                    }
                    remove_btn(self.find('.save'));
                },
                error: function (e) {
                    remove_btn(self.find('.save'));
                }
            });
        });
    });
</script>
@endpush