<div class="form-group row">
    <label class="col-sm-2 col-form-label text-black">{{ __('s.products') }}</label>
    <div class="col-sm-10">
        <select class="form-control select" name="product_id[]" multiple required>
            @if (!empty($products))
                @foreach ($products as $product)
                    <option value="{{ $product->id }}">{{ $product->name_en }}</option>
                @endforeach
            @endif
        </select>
    </div>
</div>

<div class="form-group row">
    <label class="col-sm-2 col-form-label text-black">{{ __('s.payment_type') }}</label>
    <div class="col-sm-10">
        <select class="form-control select" name="payment_type" required>
            <option value="">{{ __('s.select_type') }}</option>
            @foreach (\App\Http\Controllers\Booking\BookingController::get_payment_types() as $index => $payment_type)
                @php
                    if (in_array($index, ['sales_cash_cp', 'sales_visa_cp', 'free', 'wallet', 'service_cash', 'service_visa'])) {
                        continue;
                    }
                @endphp
                <option value="{{ $index }}">{{ $payment_type }}</option>
            @endforeach
        </select>
    </div>
</div>

<div class="form-group row">
    <label class="col-sm-2 col-form-label text-black">{{ __('s.discount') }}</label>
    <div class="col-sm-10">
        <select class="form-control select" name="discount">
            <option value="">{{ __('s.select_discount') }}</option>
            @for ($i = 1; $i <= 15; $i++)
                <option value="{{ $i }}">{{ $i }}%</option>
            @endfor
        </select>
    </div>
</div>
<div class="form-group row">
    <label class="col-sm-2 col-form-label text-black">{{ __('s.sales_employee') }}</label>
    <div class="col-sm-10">
        <select class="form-control select required" required name="sales_worker_id">
            <option value="">{{ __('s.select_employee') }}</option>
            @if (!empty($workers))
                @foreach ($workers as $worker)
                    <option value="{{ $worker->id }}">{{ $worker->name }} ( {{ $worker->phone }} )</option>
                @endforeach
            @endif
        </select>
    </div>
</div>

<div class="form-group row">
    <label class="col-sm-2 col-form-label text-black">{{ __('s.employee') }}</label>
    <div class="col-sm-10">
        <select class="form-control select" name="worker_id">
            <option value="">{{ __('s.select_employee') }}</option>
            @if (!empty($workers))
                @foreach ($workers as $worker)
                    <option value="{{ $worker->id }}">{{ $worker->name }} ( {{ $worker->phone }} )</option>
                @endforeach
            @endif
        </select>
    </div>
</div>

<div class="form-group row" id="content-commission" style="display: none">
    <label class="col-sm-2 col-form-label text-black">{{ __('s.commission') }}</label>
    <div class="col-sm-10">
        <select class="form-control select" name="commission">
            {{-- @foreach (commission_list() as $commission)
                <option value="{{ $commission }}">{{ $commission }}</option>
            @endforeach --}}
            @for ($i = 1; $i <= 100; $i++)
                <option value="{{ $i }}">{{ $i }}</option>
            @endfor
        </select>
    </div>
</div>
