@extends('layout')
@section('content')

    <div class="portlet box blue-hoki">
        <div class="portlet-title">
            <div class="caption">
                <i class="fa fa-plus"></i>Daily Report
            </div>
        </div>
        <div class="portlet-body">
            <div class="row">
                <form method="get" action="{{ set_route('report.daily') }}">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Date</label>
                            <input value="{{ $var }}" name="date" class="form-control date-format" required>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Branch</label>
                            <select class="form-control" name="branch_id">
                                @if(get_user_role()==1 || get_user_role()==4)
                                <option value="">All Branches</option>
                                @endif
                                @if(!empty($branches))
                                    @foreach($branches as $branch)
                                        @php
                                        $selected = '';
                                        if($branch->id==$selected_branch){
                                        $selected = 'selected=""';
                                        }
                                        @endphp
                                        <option {{ $selected }} value="{{ $branch->id }}">{{ $branch->name_en }}</option>
                                        @endforeach
                                    @endif
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>&nbsp;</label><br>
                            <button class="btn btn-success">View</button>
                            @if(isset($request) && !empty($request->has('date')))
                                <a target="_blank" href="{{ set_route('report.daily') }}?date={{ $request->get('date') }}&branch_id={{ $request->get('branch_id') }}&is_pdf=true" class="btn btn-primary">PDF</a>
                                @endif
                        </div>
                    </div>
                </form>
            </div>
            <div class="row">
                <div class="col-md-12">
                    {!! $template !!}
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
<script type="text/javascript">
    $(document).ready(function () {
       $(".date-format").datetimepicker({
           "format":"DD/MM/Y"
       });
    });
</script>
@endpush