@extends('layout')

@push('styles')
<style>
    .content-permission{
        padding-left: 30px !important;
    }
    .content-permission .permission{
        float: left;
        margin-left: 15px;

    }
    .content-permission .permission span{
        vertical-align: top;
    }
    .content-permission .permission:first-child{
        margin-left: 0;
    }
</style>
@endpush

@section('content')
    <form id="create_admin" autocomplete="nope" enctype="multipart/form-data">
        <div class="portlet box blue-hoki">
            <div class="portlet-title">
                <div class="caption">
                    @if(isset($role))
                        <i class="fa fa-edit"></i>
                        {{__('s.edit_role')}}
                        @else
                        <i class="fa fa-plus"></i>
                    {{__('s.create_role')}}
                        @endif
                </div>
            </div>
            <div class="portlet-body">
                <input type="hidden" name="_token" value="{{ csrf_token() }}">
                <div class="row">
                    <div class="col-md-2">
                        <label>{{__('s.name')}}<span class="required">*</span></label>
                        <input required type="text" class="form-control" name="name" value="@if(isset($role)){{ $role->name }}@endif">
                    </div>
                </div>
            </div>
        </div>
        <div class="portlet box blue-hoki">
            <div class="portlet-title">
                <div class="caption">
                    {{ __('s.permissions') }}
                </div>
            </div>
            <div class="portlet-body">
                @include('role.permission')
            </div>
            <div class="portlet-footer">
                <button type="submit" class="btn btn-success save">Save</button>&nbsp;&nbsp;
                <a href="{{ url('role') }}" class="btn btn-danger">Cancel</a>
            </div>
        </div>
    </form>

    <!-- script -->
    <script type="text/javascript">
        $(document).ready(function () {
            $(document).on("submit", "#create_admin", function (e) {
                var self = $(this);
                var form_url = "{{ url('role/store') }}";
                @if(isset($role))
                    form_url = "{{ url('role/'.$role->id.'/update') }}";
                @endif
                e.preventDefault();
                self.find(".save").html('Processing...');
                self.find(".save").attr("disabled","disabled");
                $.ajax({
                    "url": form_url,
                    "type": "POST",
                    "dataType": "JSON",
                    data: new FormData(this),
                    contentType: false,
                    cache: false,
                    processData: false,
                    "success": function (data) {
                        if(data.success){
                            window.location = '{{ url('role') }}';
                        }else{
                            self.find(".save").html('Save');
                            self.find(".save").removeAttr("disabled");
                            toastr.error(data.message,toastar_options);
                        }
                    },
                    "error": function () {
                        self.find(".save").html('Save');
                        self.find(".save").removeAttr("disabled");
                    }
                });
            });


            $(document).on("change",".select-all-row",function (e) {
                var self = $(this);
                if(self.is(":checked")){
                    self.closest("tr").find(".single-p").prop("checked",true);
                }else{
                    self.closest("tr").find(".single-p").prop("checked",false);
                }
            });

            $(document).on("change",".select-all-column",function (e) {
                var self = $(this);
                var index = self.closest("td").index();
                if(self.hasClass("select-all-table")){
                    if (self.is(":checked")) {
                        self.closest("table").find("input[type=checkbox]").prop("checked", true);
                    } else {
                        self.closest("table").find("input[type=checkbox]").prop("checked", false);
                    }
                }else {
                    if (self.is(":checked")) {
                        self.closest("table").find(".content-single-row-permission").find("td:eq(" + index + ") .single-p").prop("checked", true);
                    } else {
                        self.closest("table").find(".content-single-row-permission").find("td:eq(" + index + ") .single-p").prop("checked", false);
                    }
                }
            });


        });
    </script>

@endsection