<div class="form-group row">
    <label class="col-sm-3 col-form-label text-black">{{ __('s.worker') }}
    </label>
    <div class="col-sm-9">
        <input type="hidden" name="worker_id" value="{{ $worker->id }}">
        {{ $worker->name }}
    </div>
</div>

<div class="form-group row">
    <label class="col-sm-3 col-form-label text-black">{{ __('s.day') }}
        <span class="text-danger">*</span>
    </label>
    <div class="col-sm-9">
        <input type="text" class="form-control date-format" name="day" required>
    </div>
</div>

<div class="form-group row">
    <label class="col-sm-3 col-form-label text-black">{{ __('s.description') }}
        <span class="text-danger">*</span>
    </label>
    <div class="col-sm-9">
        <textarea class="form-control" name="describe" required></textarea>
    </div>
</div>

<h1>All Vacations</h1>
<table class="table table-bordered" id="all_vacations">
    <thead>
    <tr>
        <th>Day</th>
        <th>Description</th>
		<th>Action</th>
		
    </tr>
    </thead>
    <tbody>
    @if(!empty($worker->vacations))
        @foreach($worker->vacations as $vacation)
            <tr>
                <td>{{ $vacation->day }}</td>
                <td>{{ $vacation->describe }}</td>
				
				 <td>
					<form action="{{route('worker.vacation.delete', ['id' => $vacation->id]) }}" method="get">
					
						<button type="submit" class="btn btn-danger">Delete</button>
					</form>

			    </td>

            </tr>
            @endforeach
        @endif
    </tbody>
</table>

