<?php
use Illuminate\Support\Facades\Route;

Route::group(['prefix' => '{locale}', 'where' => ['locale' => '[a-zA-Z]{2}']], function () {
    Route::group(['middleware' => ['setlocale','auth']], function () {
        Route::group(['prefix'=>'booking'],function(){
            Route::get('/',[App\Http\Controllers\Booking\BookingController::class, 'index'])->name('booking');
            Route::get('/tips',[App\Http\Controllers\Booking\BookingController::class, 'index_tips'])->name('booking_tips');
            Route::get('/getWorker',[App\Http\Controllers\Booking\BookingController::class, 'get_workers'])->name('booking.worker.get');
            Route::post('/getTimes',[App\Http\Controllers\Booking\BookingController::class, 'get_times'])->name('booking.times.get');
            Route::post('/save',[App\Http\Controllers\Booking\BookingController::class, 'save_bookings'])->name('booking.save');
            Route::get('/getDataTable',[App\Http\Controllers\Booking\BookingController::class, 'getDataTable'])->name('booking.datatable.get');
            Route::get('/getDataTable-tips',[App\Http\Controllers\Booking\BookingController::class, 'getDataTable_tips'])->name('booking.datatable.get_tips');
            Route::get('/print-invoice',[App\Http\Controllers\Booking\BookingController::class, 'print_invoice'])->name('booking.invoice.print');
            Route::get('/print_invoice_tips',[App\Http\Controllers\Booking\BookingController::class, 'print_invoice_tips'])->name('booking.invoice.print_tips');
            Route::post('/get-wallet',[App\Http\Controllers\Booking\BookingController::class, 'get_wallet'])->name('booking.wallet.get');
            Route::post('/check-time',[App\Http\Controllers\Booking\BookingController::class, 'check_time'])->name('booking.time.check');
            Route::get('/{id}/delete','Booking\BookingController@destroy')->name('booking.delete');
            // Route::post('/save-booking', 'Booking\BookingController@saveBooking')->name('save-booking');
            Route::get('/{id}/edit-date', 'Booking\BookingController@editDate')->name('booking.edit');
            Route::post('/update-date', 'Booking\BookingController@updateDate')->name('booking.update.date');
            Route::get('/getUsersByBranch', 'Booking\BookingController@getUsersByBranch')->name('get.users.by.branch');


        });

        //but products
        Route::group(['prefix'=>'buy-products'],function(){
            Route::get('/',[App\Http\Controllers\Booking\BuyProductController::class, 'index'])->name('buy.product');
            Route::post('/store',[App\Http\Controllers\Booking\BuyProductController::class, 'store'])->name('buy.product.store');
            Route::get('/delete',[App\Http\Controllers\Booking\BuyProductController::class, 'destroy'])->name('buy.product.delete');
            Route::get('/print',[App\Http\Controllers\Booking\BuyProductController::class, 'print_invoice'])->name('buy.product.print');
        });
    });
});