<?php
use Illuminate\Support\Facades\Route;

Route::group(['prefix' => '{locale}', 'where' => ['locale' => '[a-zA-Z]{2}']], function () {
    Route::group(['middleware' => ['setlocale','auth','admin.super']], function () {
        Route::group(['prefix'=>'branch'],function(){
            Route::get('/','Branch\BranchController@index')->name('branch');
            Route::post('/store','Branch\BranchController@store')->name('branch.store');
            Route::get('/edit','Branch\BranchController@edit')->name('branch.edit');
            Route::post('/update','Branch\BranchController@update')->name('branch.update');
            Route::get('/{id}/delete','Branch\BranchController@destroy')->name('branch.delete');
        });
    });
});