<?php
use Illuminate\Support\Facades\Route;

Route::group(['prefix' => '{locale}', 'where' => ['locale' => '[a-zA-Z]{2}']], function () {
    Route::group(['middleware' => ['setlocale','auth']], function () {
        Route::group(['prefix'=>'report'],function(){
            Route::get('/daily-report','Report\ReportController@daily_report')->name('report.daily');
            Route::get('/commission-report','Report\ReportController@commissions')->name('report.commission_reports');
            Route::get('/tips-report','Report\ReportController@staff_tips')->name('report.tips_reports');
            Route::get('/sales','Report\ReportController@sales')->name('report.sales');
            Route::get('/staff','Report\ReportController@staff')->name('report.staff');
        });
    });
});
