<?php
use Illuminate\Support\Facades\Route;

Route::group(['prefix' => '{locale}', 'where' => ['locale' => '[a-zA-Z]{2}']], function () {
    Route::group(['middleware' => ['setlocale','auth','admin.super']], function () {
        Route::group(['prefix'=>'service'],function(){
            Route::get('/','Service\ServiceController@index')->name('service');
            Route::post('/store','Service\ServiceController@store')->name('service.store');
            Route::get('/edit','Service\ServiceController@edit')->name('service.edit');
            Route::post('/update','Service\ServiceController@update')->name('service.update');
            Route::get('/{id}/delete','Service\ServiceController@destroy')->name('service.delete');
        });
    });
});