<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Session;
use Symfony\Component\Process\Process;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Hash;



/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
// Route::get('/',function (){
//     return redirect()->to(app()->getLocale());
// });

Route::get('/system-settings', 'SystemSettingsController@index')->name('system_settings.index')->middleware('auth');;
Route::post('/system-settings', 'SystemSettingsController@store')->name('system_settings.store')->middleware('auth');;
Route::get('/vacation-delete/{id}', 'Worker\WorkerController@delete_vacation')->name('worker.vacation.delete')->middleware('auth');


Route::get('/composer-update', function () {
    // Define the Composer update command
    $command = 'composer update';

    // Create a Symfony Process to run the Composer update command
    $process = Process::fromShellCommandline($command);

    // Run the Composer update command
    $process->run();
});
Route::get('/','DashboardController@home');
Route::group(['prefix' => '{locale}', 'where' => ['locale' => '[a-zA-Z]{2}']], function () {
    Route::group(['middleware' => ['setlocale','auth']], function () {
        Route::get('/','DashboardController@index')->name('dashboard');
    });
});
//for login
Route::get('login', [ 'as' => 'login', 'uses' => 'LoginController@index']);
Route::post('doLogin', [ 'as' => 'doLogin', 'uses' => 'LoginController@doLogin']);
Route::get('logout', [ 'as' => 'logout', 'uses' => 'LoginController@logout']);
Route::post('reset-password', [ 'as' => 'res', 'uses' => 'LoginController@reset_password']);
Route::post('change-password', [ 'as' => 'change_password', 'uses' => 'LoginController@change_password']);

// Route::get('/clear/route', function (){
//     dd(\Artisan::call('view:clear'));
// });

// Route::get('/storage-link', function (){
//     dd(\Artisan::call('storage:link'));
// });

Route::get('/reset-passwordprocess/{token}', 'ResetPasswordController@showResetForm')->name('password.reset');
Route::post('/reset-passwordprocess', 'ResetPasswordController@reset')->name('password.update');


Route::get('/download/backup','Reservation\BackupController@download')->name('resvBackupDownload');
Route::get('/clear/route','DashboardController@clearCache');
//Route::post('/booking/get-services', [ 'as' => 'booking.services.get', 'uses' => 'BookingController@get_booking_services']);
//Route::POST('/booking/get-services','BookingController@get_booking_services')->name('user_services');

