<?php
use Illuminate\Support\Facades\Route;

Route::group(['prefix' => '{locale}', 'where' => ['locale' => '[a-zA-Z]{2}']], function () {
    Route::group(['middleware' => ['setlocale','auth']], function () {
        Route::group(['prefix'=>'worker'],function(){
            Route::get('/','Worker\WorkerController@index')->name('worker');
            Route::post('/store','Worker\WorkerController@store')->name('worker.store');
            Route::get('/edit','Worker\WorkerController@edit')->name('worker.edit');
            Route::post('/update','Worker\WorkerController@update')->name('worker.update');
            Route::get('/{id}/delete','Worker\WorkerController@destroy')->name('worker.delete');
			
            Route::get('/get-vacation','Worker\WorkerController@get_vacation')->name('worker.vacation.get');
			
            Route::post('/save-vacation','Worker\WorkerController@save_vacation')->name('worker.vacation.save');
			

        });

        Route::group(['prefix'=>'week-day'],function(){
            Route::get('/','Worker\WeekDayController@index')->name('weekday');
            Route::get('/update','Worker\WeekDayController@update')->name('weekday.update');
        });
    });
});
