<div class="modal " ref="create_booking" id="create_booking" tabindex="-1" role="dialog"
     aria-labelledby="createAccountModalLabel" aria-hidden="true"
     data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog modal-lg" role="document">
        <form class="modal-content" method="post">
            <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
            <div class="modal-header">
                <h5 class="modal-title text-black" id="createAccountModalLabel"><?php echo e(__('Create New Booking With Tips')); ?></h5>
                <button type="button" class="close" aria-label="Close" data-dismiss="modal">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <div class="modal-body">
            <h4 class="text-center"><?php echo e('Booking Details'); ?></h4>
            <?php if(\Illuminate\Support\Facades\Auth::user()->role_id==1): ?>
            
                <div class="modal-body">
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Branch</label>
                                <select class="form-control" name="branch_id" id="branch_id">
                                    <?php if(\Illuminate\Support\Facades\Auth::user()->role_id == 1): ?>
                                        <option value="">All Branches</option>
                                    <?php endif; ?>
                                    <?php echo e($branches = \App\Models\Branch::where('id', '>', 0)->get()); ?> 
                                    <?php dump($branches); ?>;
                                    <?php if(!empty($branches)): ?>
                                        <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $selected = '';
                                                $user_branch_id = \Illuminate\Support\Facades\Auth::user()->branch_id;

                                                if ($branch->id == $user_branch_id) {
                                                    $selected = 'selected="selected"';
                                                }
                                            ?>
                                            <option <?php echo e($selected); ?> value="<?php echo e($branch->id); ?>"><?php echo e($branch->name_en); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Worker</label>
                                <select class="form-control" name="worker_id" id="worker_id">
                                    <option value="">Select a Branch first</option>
                                    <!-- Workers for selected branch will be populated here -->
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="booking_date_time">Booking Date and Time</label>
                                <input type="datetime-local" class="form-control" id="booking_date_time" name="booking_date_time"
                                value="<?php echo e(\Carbon\Carbon::now()->format('Y-m-d\TH:i')); ?>">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="tip">Tips (Between 0 and 200)</label>
                                <input type="number" class="form-control" id="tip" name="tip" min="0" max="200">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Payment Method</label>
                                <select class="form-control" name="payment_type" required>
                                    <option value=""><?php echo e(('Select Payment')); ?></option>
                                    <?php $__currentLoopData = App\Http\Controllers\Booking\BookingController::get_payment_types(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index=>$payment_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            if(in_array($index,['sales_cash_cp','sales_visa_cp','free','sales_cash','sales_visa','wallet','service_cash','service_visa'])){
                                                continue;
                                            }
                                        ?>
                                        <option value="<?php echo e($index); ?>"><?php echo e($payment_type); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div> 
                        </div>
                    </div>
                    <ul class="list-inline pull-right">
                        <!-- Additional elements or buttons can be placed here -->
                    </ul>
                </div>
            

            <?php else: ?>
            <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label><?php echo e('Worker'); ?></label>
                            <select class="form-control service-select select" name="worker_id">
                                <?php $__currentLoopData = \App\Http\Controllers\Booking\BookingController::get_all_workers_for_my_branch(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $worker): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if(isset($worker) && !empty($worker)): ?>
                                        <option value="<?php echo e($worker->id); ?>"><?php echo e($worker->name); ?></option>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    

                     
                </div>
                <div class="row">
                    
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="tip">Tips (Between 0 and 200)</label>
                            <input type="number" class="form-control" id="tip" name="tip" min="0" max="200">
                        </div>
                    </div>
                </div>   
                <div class="row">
                    <div class="col-md-12">  
                    <div class="form-group">          
                        <label>Payment Method</label>
                        <select class="form-control" name="payment_type" required>
                            <option value=""><?php echo e(('Select Payment')); ?></option>
                            <?php $__currentLoopData = App\Http\Controllers\Booking\BookingController::get_payment_types(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index=>$payment_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                
                            <?php
                                    if(in_array($index,['sales_cash_cp','sales_visa_cp','free','sales_cash','sales_visa','wallet','service_cash','service_visa'])){
                                    continue;
                                    }
                                ?>
                                <option value="<?php echo e($index); ?>"><?php echo e($payment_type); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div> 
                    </div>  
  
                    

                </div>
                <ul class="list-inline pull-right">

                </ul>
            </div>
            <?php endif; ?>  
             
            <div class="modal-footer">
            
            <ul class="list-inline pull-right">
                <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('close')); ?></button>
               
                
                <li><button type="submit" class="btn btn-success save-booking"><?php echo e(__('Create Booking')); ?></button></li>

            </ul>
            </div>
        </form>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    $(document).ready(function() {
        $('select[name="branch_id"]').change(function() {
            var selectedBranch = $(this).val();
            var workerDropdown = $('select[name="worker_id"]');
            
            workerDropdown.empty().append('<option value="">Select a Branch first</option>');

            if (selectedBranch !== '') {
                $.ajax({
                    url: '<?php echo e(route("get.users.by.branch", ['locale' => app()->getLocale()])); ?>',
                    method: 'GET',
                    data: { branch_id: selectedBranch },
                    success: function(response) {
                        workerDropdown.empty().append('<option value="">Select a Worker</option>');
                        $.each(response.users, function(index, user) {
                            workerDropdown.append('<option value="' + user.id + '">' + user.name + '</option>');
                        });
                    },
                    error: function(xhr, status, error) {
                        console.error(error);
                    }
                });
            }
        });

        // Trigger change event on page load if a branch is selected by default
        $('select[name="branch_id"]').trigger('change');
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('booking.tabs.script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /home/etechnoc/public_html/meenscare/resources/views/booking/tips_modal.blade.php ENDPATH**/ ?>