<script type="text/javascript">
    $(document).ready(function () {
        $(".time-only").datetimepicker({format: 'HH:mm'});
        var table = $("table").dataTable({
            processing: true,
            serverSide: true,
            ajax: "<?php echo e(set_route('worker')); ?>",
            columns: [
                {data: 'id', name: 'id'},
                {data: 'branch_id', name: 'branch_id'},
                {data: 'services', name: 'services'},
                {data: 'name', name: 'name'},
                {data: 'email', name: 'email'},
                {data: 'phone', name: 'phone'},
                {data: 'status', name: 'status'},
                {data: 'image', name: 'image'},
                {
                    data: 'action', name: 'action',
                    orderable: false, searchable: false
                },
            ]
        });

        $("#accountForm").validate({
            rules: {
                price: {
                    number: true
                }
            }
        });
        $(document).on("submit", "#accountForm", function (e) {
            e.preventDefault();
            var self = $(this);
            // Get form
            var form = self[0];
            // FormData object
            var data = new FormData(form);
            load_btn(self.find('.save'));
            $.ajax({
                type: "POST",
                enctype: 'multipart/form-data',
                url: "<?php echo e(set_route('worker.store')); ?>",
                data: data,
                processData: false,
                contentType: false,
                cache: false,
                timeout: 800000,
                success: function (data) {
                    if (data.success) {
                        location.reload();
                    } else {
                        toastr.error(data.message, toastar_options);
                    }
                    remove_btn(self.find('.save'));
                },
                error: function (e) {
                    remove_btn(self.find('.save'));
                }
            });
        });
        //edit worker
        $(document).on("click", ".edit-worker", function (e) {
            var self = $(this);
            $.ajax({
                "url": "<?php echo e(set_route('worker.edit')); ?>?id=" + self.data("id"),
                "type": "GET",
                "dataType": "JSON",
                "data": {},
                "success": function (data) {
                    var row = data.row;
                    var service_id = data.service_id;
                    $("#editModal .form-control").each(function () {
                        var field_name = $(this).attr("name");
                        if (row[field_name] != undefined) {
                            if (field_name != "image" && field_name != "service_id[]") {
                                $(this).val(row[field_name])
                            }
                            if (field_name === "image" && row[field_name] != "") {
                                $("#editModal .content-image").html('<img width="150px" src="<?php echo e(\Illuminate\Support\Facades\Storage::url('')); ?>' + row[field_name] + '">');
                            }
                        }
                    });

                    $("#editModal .service-select").select2('destroy');
                    $("#editModal .service-select option").each(function () {
                        for (var i = 0; i < service_id.length; i++) {
                            if ($(this).val() == service_id[i]) {
                                $(this).attr("selected", "selected");
                            }
                        }
                    });
                    $("#editModal .service-select").select2();
                },
                "error": function () {

                }
            });
        });
        $(document).on("submit", "#editForm", function (e) {
            e.preventDefault();
            var self = $(this);
            // Get form
            var form = self[0];
            // FormData object
            var data = new FormData(form);
            load_btn(self.find('.save'));
            $.ajax({
                type: "POST",
                enctype: 'multipart/form-data',
                url: "<?php echo e(set_route('worker.update')); ?>",
                data: data,
                processData: false,
                contentType: false,
                cache: false,
                timeout: 800000,
                success: function (data) {
                    if (data.success) {
                        $("#editModal").modal('hide');
                        table.fnDraw();
                        toastr.success(data.message, toastar_options);
                    } else {
                        toastr.error(data.message, toastar_options);
                    }
                    remove_btn(self.find('.save'));
                },
                error: function (e) {
                    remove_btn(self.find('.save'));
                }
            });
        });
        //add-vacation
        $(document).on("click", ".add-vacation", function (e) {
            var self = $(this);
            var name = self.data("name");
            $("#vacationModal .title").text(name);
            $("#vacationModal .modal-body").html('<img width="50px" src="<?php echo e(url('assets/img/loading.gif')); ?>">');
            $.ajax({
                "url": "<?php echo e(set_route('worker.vacation.get')); ?>"+'?id='+self.data("id"),
                "type": "GET",
                "dataType": "JSON",
                "data": {},
                "success": function (data) {
                    $("#vacationModal .modal-body").html(data.view);
                    $(".date-format").datetimepicker({format: 'D/M/Y'});
                    $("#all_vacations").dataTable();
                },
                "error": function () {

                }
            });
        });
        //send form
        $(document).on("submit", "#vacationForm", function (e) {
            e.preventDefault();
            var self = $(this);
            // Get form
            var form = self[0];
            // FormData object
            var data = new FormData(form);
            load_btn(self.find('.save'));
            $.ajax({
                type: "POST",
                enctype: 'multipart/form-data',
                url: "<?php echo e(set_route('worker.vacation.save')); ?>",
                data: data,
                processData: false,
                contentType: false,
                cache: false,
                timeout: 800000,
                success: function (data) {
                    if (data.success) {
                        location.reload();
                    } else {
                        toastr.error(data.message, toastar_options);
                    }
                    remove_btn(self.find('.save'));
                },
                error: function (e) {
                    remove_btn(self.find('.save'));
                }
            });
        });
    });
</script><?php /**PATH /home/menscare/public_html/test/resources/views/worker/script.blade.php ENDPATH**/ ?>