

<?php $__env->startPush('styles'); ?>
<?php echo $__env->make('booking.styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>

    <div class="portlet box blue-hoki">
        <div class="portlet-title">
            <div class="caption">
                <i class="fa fa-plus"></i>Booking List For Tips
            </div>
            <?php if(can('user.create')): ?>
                <a style="margin: 5px 0" href="" data-toggle="modal" data-target="#create_booking" class="btn btn-success pull-right">
                    <?php echo e(__('s.Create New Booking With Tips')); ?>

                </a>
            <?php endif; ?>
        </div>
        <div class="portlet-body">
            <table id="booking_table3" class="table table-bordered table-stripped">
                <thead>
                <tr>
                    <th>#</th>
                    <th>Branch </th>
                    <th>Date&Time</th>
                    <th>Worker Name</th>
                    <th>Tips</th>
                    <th>Created By</th> <!-- Added 'Created By' column -->
                    <th>Actions</th>
                     </tr>
                </thead>
                <tbody>
                    <?php if(!$booking_tips_list->isEmpty()): ?>
                        <?php $__currentLoopData = $booking_tips_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(\Illuminate\Support\Facades\Auth::user()->role_id == 1 || (\Illuminate\Support\Facades\Auth::user()->role_id == 2 && $item->branch_id == \Illuminate\Support\Facades\Auth::user()->branch_id)): ?>

                            <tr>
                                <td><?php echo e($item->id); ?></td>
                                <td>
                                    <?php if(!empty($item->branch)): ?>
                                        <?php echo e($item->branch->name_en); ?>

                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php echo e($item->details->first()->_date ?? ''); ?>

                                </td>
                                <td>
                                    <?php echo e(\App\Models\Worker::where('id', $item->details->first()->worker_id)->value('name')); ?>

                                </td>
                                <td>
                                    <?php echo e($item->details->first()->tip ?? ''); ?>

                                </td>
                                <td>
                                    
                                    <?php echo e(isset($item->user) ? $item->user->first_name . ' ' . $item->user->last_name : 'Not Found'); ?>

                                </td>
                                <td>
                                    
                                    <?php
                                        $template = "<a data-id='" . $item->id . "' href='" . set_route('booking.invoice.print') . "?id=" . $item->id . "' target='_blank'  class='btn btn-primary btn-sm print-row'><i class='fa fa-print'></i></a>";
                                       
                                        if(\Illuminate\Support\Facades\Auth::user()->role_id == 1) {
                                            $template .= "<a data-id='" . $item->id . "' href='" . set_route('booking.delete', ['id' => $item->id]) . "' class='btn btn-danger btn-xs delete-row'><i class='fa fa-times'></i></a>";
                                                                                   }
                                        echo $template;
                                    ?>

                                        <?php if(\Illuminate\Support\Facades\Auth::user()->role_id ==1): ?>

                                        <button class="btn btn-info btn-xs edit-row" data-id="<?php echo e($item->id); ?>"><i class='fa fa-pencil'></i> Edit</button>
                                            <form class="edit-form hidden" id="edit-form-<?php echo e($item->id); ?>" data-id="<?php echo e($item->id); ?>">
                                                <input type="date" name="edited_date" value="<?php echo e($item->details->first()->_date ?? ''); ?>">
                                                <button type="submit" class="btn btn-success btn-xs save-row"><i class='fa fa-save'></i> Save</button>
                                            </form>
                                        <?php endif; ?>         
                                </td>
                                
                            </tr>
                        <?php endif; ?>    
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php echo $__env->make('booking.tips_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>



<?php $__env->startPush('scripts'); ?>
    <?php echo $__env->make('booking.script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
<?php $__env->stopPush(); ?>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.edit-row').click(function(e) {
                e.preventDefault();
                var itemId = $(this).data('id');
                $('#edit-form-' + itemId).removeClass('hidden');
            });

            $('.edit-form').submit(function(e) {
                e.preventDefault();
                var itemId = $(this).data('id');
                var editedDate = $(this).find('input[name="edited_date"]').val();
                console.log('kll;l');

                $.ajax({
                    method: 'POST',
                    url: '<?php echo e(route('booking.update.date', ['locale' => 'en'])); ?>', // Replace 'en' with the appropriate locale value
                    data: {
                        id: itemId,
                        edited_date: editedDate,
                        _token: '<?php echo e(csrf_token()); ?>'
                    },
                    success: function(response) {
                        console.log('Date updated successfully');
                        $('#edit-form-' + itemId).addClass('hidden');
                        // You might update the displayed date here on success
                    },
                    error: function(err) {
                        console.error('Error updating date:', err);
                    }
                });


            });
        });
    </script>
<?php echo $__env->make('layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/technosystems/public_html/resources/views/booking/index_tips.blade.php ENDPATH**/ ?>